/*
 * Decompiled with CFR 0.152.
 */
package randoop.output;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import randoop.main.Minimize;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.output.ClassRenamingVisitor;
import randoop.output.CodeWriter;
import randoop.output.JavaFileWriter;
import randoop.output.RandoopOutputException;

public class MinimizerWriter
implements CodeWriter {
    private final @SignatureUnknown JavaFileWriter javaFileWriter;

    public MinimizerWriter(@SignatureUnknown JavaFileWriter javaFileWriter) {
        this.javaFileWriter = javaFileWriter;
    }

    @Override
    public @SignatureUnknown Path writeClassCode(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String classCode) throws @SignatureUnknown RandoopOutputException {
        Path testFile = this.javaFileWriter.writeClassCode(packageName, classname, classCode);
        try {
            Minimize.mainMinimize(testFile, System.getProperty("java.class.path"), Minimize.testsuitetimeout, Minimize.verboseminimizer);
        }
        catch (IOException e) {
            throw new RandoopOutputException(e);
        }
        String minimizedClassName = Minimize.minimizedClassName(testFile);
        Path minimizedFile = testFile.resolveSibling(minimizedClassName + ".java");
        try {
            Path testFile2 = ClassRenamingVisitor.copyAndRename(minimizedFile, classname);
            assert (testFile.equals(testFile2));
            Files.delete(minimizedFile);
        }
        catch (IOException e) {
            throw new RandoopBug(String.format("Problem while renaming %s to %s", minimizedFile, testFile), e);
        }
        return testFile;
    }

    @Override
    public @SignatureUnknown Path writeUnmodifiedClassCode(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String classCode) throws @SignatureUnknown RandoopOutputException {
        return this.javaFileWriter.writeClassCode(packageName, classname, classCode);
    }
}

