/*
 * Decompiled with CFR 0.152.
 */
package randoop.output;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.output.CodeWriter;
import randoop.output.RandoopOutputException;

public class JavaFileWriter
implements CodeWriter {
    private final @SignatureUnknown String dirName;

    public JavaFileWriter(@SignatureUnknown String junitDirName) {
        this.dirName = junitDirName;
    }

    @Override
    public @SignatureUnknown Path writeClassCode(@SignatureUnknown String packageName, @SignatureUnknown String className, @SignatureUnknown String classCode) throws @SignatureUnknown RandoopOutputException {
        Path dir = this.createOutputDir(packageName);
        Path file = new File(dir.toFile(), className + ".java").toPath();
        try (PrintWriter out = new PrintWriter(file.toFile(), StandardCharsets.UTF_8.name());){
            out.println(classCode);
        }
        catch (IOException e) {
            String message = "Exception creating print writer for file " + file.toString();
            throw new RandoopOutputException(message, e);
        }
        return file;
    }

    @Override
    public @SignatureUnknown Path writeUnmodifiedClassCode(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String classCode) throws @SignatureUnknown RandoopOutputException {
        return this.writeClassCode(packageName, classname, classCode);
    }

    private @SignatureUnknown Path createOutputDir(@SignatureUnknown String packageName) throws @SignatureUnknown RandoopOutputException {
        boolean success;
        Path dir = this.getDir(packageName);
        if (!Files.exists(dir, new LinkOption[0]) && !(success = dir.toFile().mkdirs())) {
            throw new RandoopOutputException("Unable to create directory: " + dir.toAbsolutePath());
        }
        return dir;
    }

    private @SignatureUnknown Path getDir(@SignatureUnknown String packageName) {
        String[] split;
        Path dir = this.dirName == null || this.dirName.length() == 0 ? Paths.get(System.getProperty("user.dir"), new String[0]) : Paths.get(this.dirName, new String[0]);
        if (packageName == null) {
            return dir;
        }
        if (packageName.length() == 0) {
            return dir;
        }
        for (String s2 : split = packageName.split("\\.")) {
            dir = new File(dir.toFile(), s2).toPath();
        }
        return dir;
    }
}

