/*
 * Decompiled with CFR 0.152.
 */
package randoop.output;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import randoop.Globals;
import randoop.compile.FileCompiler;
import randoop.execution.RunCommand;
import randoop.execution.TestEnvironment;
import randoop.generation.AbstractGenerator;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.main.RandoopUsageError;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.plumelib.util.UtilPlume;
import randoop.output.CodeWriter;
import randoop.output.JavaFileWriter;
import randoop.output.RandoopOutputException;

public class FailingAssertionCommentWriter
implements CodeWriter {
    private static final @SignatureUnknown Pattern FAILURE_MESSAGE_PATTERN = Pattern.compile("There\\s+(?:was|were)\\s+(\\d+)\\s+failure(?:s|):");
    private static final @SignatureUnknown Pattern FAILURE_HEADER_PATTERN = Pattern.compile("\\d+\\)\\s+(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:\\.<init>)?\\)");
    private static final @SignatureUnknown String TYPE_REGEX = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:<[^=;]*>)?(?:\\[\\])*";
    private static final @SignatureUnknown Pattern VARIABLE_DECLARATION_LINE = Pattern.compile("^([ \t]*(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(?:\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*(?:<[^=;]*>)?(?:\\[\\])*)[ \t]+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*[ \t]*=[ \t]*)(.*)$");
    private final @SignatureUnknown TestEnvironment testEnvironment;
    private final @SignatureUnknown JavaFileWriter javaFileWriter;
    private final @SignatureUnknown HashSet<@SignatureUnknown String> flakyTestNames = new HashSet();

    public FailingAssertionCommentWriter(@SignatureUnknown TestEnvironment testEnvironment, @SignatureUnknown JavaFileWriter javaFileWriter) {
        this.testEnvironment = testEnvironment;
        this.javaFileWriter = javaFileWriter;
    }

    public @SignatureUnknown TreeSet<@SignatureUnknown String> getFlakyTestNames() {
        return new TreeSet<String>(this.flakyTestNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @SignatureUnknown Path writeClassCode(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String classSource) throws @SignatureUnknown RandoopOutputException {
        assert (!Objects.equals(packageName, ""));
        String qualifiedClassname = packageName == null ? classname : packageName + "." + classname;
        int iteration = 0;
        boolean passing = false;
        while (!passing) {
            Path workingDirectory = this.createWorkingDirectory(classname, iteration);
            try {
                this.compileTestClass(packageName, classname, classSource, workingDirectory);
            }
            catch (FileCompiler.FileCompilerException e) {
                classSource = this.commentCatchStatements(packageName, classSource, e.getDiagnostics().getDiagnostics(), workingDirectory, e);
                UtilPlume.deleteDir(workingDirectory.toFile());
                ++iteration;
                continue;
            }
            try {
                RunCommand.Status status;
                try {
                    status = this.testEnvironment.runTest(qualifiedClassname, workingDirectory);
                }
                catch (RunCommand.CommandException e) {
                    throw new RandoopBug("Error filtering regression tests", e);
                }
                if (status.exitStatus == 0) {
                    passing = true;
                    continue;
                }
                if (status.timedOut) {
                    throw new Error("runTest timed out for class " + qualifiedClassname + ": " + status);
                }
                if (status.exitStatus == 137) {
                    System.out.printf("runTest exit status 137 in FailingAssertionCommentWriter.writeClassCode(%s, %s)%n", packageName, classname);
                    System.out.printf("classSource:%n", new Object[0]);
                    System.out.println(classSource);
                    throw new Error("runTest exit status 137 for class " + qualifiedClassname + ": " + status + "classSource: " + classSource);
                }
                classSource = this.commentFailingAssertions(packageName, classname, classSource, status, this.flakyTestNames);
            }
            finally {
                UtilPlume.deleteDir(workingDirectory.toFile());
                ++iteration;
            }
        }
        return this.javaFileWriter.writeClassCode(packageName, classname, classSource);
    }

    @Override
    public @SignatureUnknown Path writeUnmodifiedClassCode(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String javaCode) throws @SignatureUnknown RandoopOutputException {
        return this.javaFileWriter.writeClassCode(packageName, classname, javaCode);
    }

    private @SignatureUnknown String commentCatchStatements(@SignatureUnknown String packageName, @SignatureUnknown String javaCode, @SignatureUnknown List<@SignatureUnknown Diagnostic<@SignatureBottom ? extends @SignatureUnknown JavaFileObject>> diagnostics, @SignatureUnknown Path destinationDir, @SignatureUnknown FileCompiler.FileCompilerException e) {
        assert (!Objects.equals(packageName, ""));
        String[] javaCodeLines = javaCode.split(Globals.lineSep);
        for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            String msg = diagnostic.getMessage(null);
            int lineNumber = (int)diagnostic.getLineNumber();
            if (msg.contains("is never thrown in body of corresponding try statement")) {
                javaCodeLines[lineNumber - 1] = "// flaky: " + javaCodeLines[lineNumber - 1];
                continue;
            }
            if (msg.contains("'try' without 'catch', 'finally' or resource declarations")) {
                javaCodeLines[lineNumber - 1] = "{ // flaky: " + javaCodeLines[lineNumber - 1];
                continue;
            }
            System.out.println("unhandled diagnostic: " + diagnostic.getMessage(null));
            this.compilationError(destinationDir, javaCode, diagnostics, e);
        }
        return UtilPlume.joinLines(javaCodeLines);
    }

    private void compilationError(@SignatureUnknown Path destinationDir, @SignatureUnknown String classSource, @SignatureUnknown List<@SignatureUnknown Diagnostic<@SignatureBottom ? extends @SignatureUnknown JavaFileObject>> diagnostics, @SignatureUnknown FileCompiler.FileCompilerException e) {
        String message = String.format("Compilation error during flaky-test filtering: fileCompiler.compile(%s, %s)%n", "sourceFile", destinationDir);
        message = GenInputsAbstract.print_non_compiling_file ? message + String.format("Source file:%n%s%n", classSource) : message + String.format("Use --print-non-compiling-file to print the file with the compilation error.%n", new Object[0]);
        message = message + String.format("Diagnostics:%n%s%n", diagnostics);
        throw new RandoopBug(message, e);
    }

    private @SignatureUnknown String commentFailingAssertions(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String javaCode, @SignatureUnknown RunCommand.Status status, @SignatureUnknown HashSet<@SignatureUnknown String> flakyTests) {
        assert (!Objects.equals(packageName, ""));
        String qualifiedClassname = packageName == null ? classname : packageName + "." + classname;
        Iterator<String> lineIterator = status.standardOutputLines.iterator();
        int totalFailures = this.numJunitFailures(lineIterator, status, qualifiedClassname, javaCode);
        String[] javaCodeLines = javaCode.split(Globals.lineSep);
        for (int failureCount = 0; failureCount < totalFailures; ++failureCount) {
            Match failureLineMatch;
            Match failureHeaderMatch = this.readUntilMatch(lineIterator, FAILURE_HEADER_PATTERN);
            String line = failureHeaderMatch.line;
            String methodName = failureHeaderMatch.group;
            if (!methodName.matches("test\\d+")) {
                System.out.println();
                System.out.printf("Failure in commentFailingAssertions(%s, %s)%n", packageName, classname);
                System.out.printf("javaCode =%n%s%n", javaCode);
                System.out.printf("status =%n%s%n", status);
                System.out.println();
                if (line.contains("initializationError")) {
                    throw new RandoopBug("Check configuration of test environment: initialization error of test in flaky-test filter: " + line);
                }
                throw new RandoopBug("Bad method name " + methodName + " in flaky-test filter: " + line);
            }
            flakyTests.add(methodName);
            Pattern linePattern = Pattern.compile(String.format("\\s+at\\s+\\Q%s\\E\\.\\Q%s\\E\\(\\Q%s\\E\\.java:(\\d+)\\)", qualifiedClassname, methodName, classname));
            try {
                failureLineMatch = this.readUntilMatch(lineIterator, linePattern);
            }
            catch (NotMatchedException e) {
                System.out.printf("failureCount = %d, totalFailures = %d%n", failureCount, totalFailures);
                System.out.println("Didn't find " + linePattern + "in:");
                for (String line2 : status.standardOutputLines) {
                    System.out.print(line2);
                }
                System.out.println("End of output for didn't find " + linePattern);
                throw e;
            }
            int lineNumber = Integer.parseInt(failureLineMatch.group);
            if (lineNumber < 1 || lineNumber > javaCodeLines.length) {
                throw new RandoopBug(String.format("Line number %d read from JUnit is out of range [1,%d]: %s", lineNumber, javaCodeLines.length, failureLineMatch.line));
            }
            if (GenInputsAbstract.flaky_test_behavior == GenInputsAbstract.FlakyTestAction.HALT) {
                int toLine;
                StringBuilder message = new StringBuilder();
                message.append(String.format("A test code assertion failed during flaky-test filtering. Most likely,%nyou ran Randoop on a program with nondeterministic behavior. See section%n\"Nondeterminism\" in the Randoop manual for ways to diagnose and handle this.%nClass: %s, Method: %s, Line number: %d, Source line:%n%s%n", classname, methodName, lineNumber, javaCodeLines[lineNumber - 1]));
                for (int fromLine = lineNumber - 1; fromLine > 0 && !javaCodeLines[fromLine].contains("@Test"); --fromLine) {
                }
                for (toLine = lineNumber; toLine < javaCodeLines.length && !javaCodeLines[toLine].contains("@Test"); ++toLine) {
                }
                message.append(String.format("Containing method:%n", new Object[0]));
                for (int i = fromLine; i < toLine; ++i) {
                    message.append(String.format("%s%n", javaCodeLines[i]));
                }
                if (GenInputsAbstract.print_non_compiling_file) {
                    message.append(String.format("Full source file:%n%s%n", javaCode));
                } else {
                    message.append(String.format("Use --print-non-compiling-file to print the full file with the flaky test.%n", new Object[0]));
                }
                throw new RandoopUsageError(message.toString());
            }
            javaCodeLines[lineNumber - 1] = this.flakyLineReplacement(javaCodeLines[lineNumber - 1]);
        }
        return UtilPlume.joinLines(javaCodeLines);
    }

    private @SignatureUnknown int numJunitFailures(@SignatureUnknown Iterator<@SignatureUnknown String> lineIterator, @SignatureUnknown RunCommand.Status status, @SignatureUnknown String qualifiedClassname, @SignatureUnknown String javaCode) {
        Match failureCountMatch;
        try {
            failureCountMatch = this.readUntilMatch(lineIterator, FAILURE_MESSAGE_PATTERN);
        }
        catch (NotMatchedException e) {
            String stderr;
            if (status.errorOutputLines.size() == 1 && (stderr = status.errorOutputLines.get(0)).equals("Error: Could not find or load main class org.junit.runner.JUnitCore")) {
                throw new RandoopUsageError("Classpath does not contain JUnit.  Please correct the classpath and re-run Randoop.");
            }
            StringBuilder errorMessage = new StringBuilder();
            if (status.exitStatus == 137) {
                errorMessage.append("Exit status 137.  Probably interrupted or out of memory.");
                errorMessage.append(Globals.lineSep);
            } else {
                errorMessage.append(String.format("Did not find \"%s\" in execution of %s%nstatus=%s%n", FAILURE_MESSAGE_PATTERN.pattern(), qualifiedClassname, status));
            }
            errorMessage.append("Standard output:");
            errorMessage.append(Globals.lineSep);
            for (String line : status.standardOutputLines) {
                errorMessage.append(line);
                errorMessage.append(Globals.lineSep);
            }
            errorMessage.append("... end of standard output.");
            errorMessage.append("Error output:");
            errorMessage.append(Globals.lineSep);
            for (String line : status.errorOutputLines) {
                errorMessage.append(line);
                errorMessage.append(Globals.lineSep);
            }
            errorMessage.append("... end of error output.");
            errorMessage.append(Globals.lineSep);
            if (AbstractGenerator.dump_sequences) {
                errorMessage.append(Globals.lineSep);
                errorMessage.append("Generated tests:");
                errorMessage.append(Globals.lineSep);
                errorMessage.append(javaCode);
            }
            if (status.exitStatus == 137) {
                throw new RandoopUsageError(errorMessage.toString(), e);
            }
            throw new RandoopBug(errorMessage.toString(), e);
        }
        int totalFailures = Integer.parseInt(failureCountMatch.group);
        if (totalFailures <= 0) {
            throw new RandoopBug("JUnit has non-zero exit status, but no failure found");
        }
        return totalFailures;
    }

    private @SignatureUnknown String flakyLineReplacement(@SignatureUnknown String flakyLine) {
        Matcher varDeclMatcher = VARIABLE_DECLARATION_LINE.matcher(flakyLine);
        if (varDeclMatcher.matches()) {
            String newInitializer;
            String varType;
            switch (varType = varDeclMatcher.group(2)) {
                case "boolean": {
                    newInitializer = "false";
                    break;
                }
                case "byte": 
                case "char": 
                case "short": 
                case "int": {
                    newInitializer = "0";
                    break;
                }
                case "long": {
                    newInitializer = "0L";
                    break;
                }
                case "float": {
                    newInitializer = "0.0f";
                    break;
                }
                case "double": {
                    newInitializer = "0.0";
                    break;
                }
                default: {
                    newInitializer = "null";
                }
            }
            return varDeclMatcher.group(1) + newInitializer + "; // flaky: " + varDeclMatcher.group(3);
        }
        return "// flaky: " + flakyLine;
    }

    private @SignatureUnknown Match readUntilMatch(@SignatureUnknown Iterator<@SignatureUnknown String> lineIterator, @SignatureUnknown Pattern pattern) {
        while (lineIterator.hasNext()) {
            String line = lineIterator.next();
            Matcher matcher = pattern.matcher(line);
            if (!matcher.matches()) continue;
            return new Match(line, matcher.group(1));
        }
        throw new NotMatchedException(pattern);
    }

    private @SignatureUnknown Path compileTestClass(@SignatureUnknown String packageName, @SignatureUnknown String classname, @SignatureUnknown String classSource, @SignatureUnknown Path destinationDir) throws @SignatureUnknown FileCompiler.FileCompilerException {
        Path sourceFile;
        try {
            sourceFile = this.javaFileWriter.writeClassCode(packageName, classname, classSource);
        }
        catch (RandoopOutputException e) {
            throw new RandoopBug("Output error during flaky-test filtering", e);
        }
        FileCompiler fileCompiler = new FileCompiler();
        fileCompiler.compile(sourceFile, destinationDir);
        return sourceFile;
    }

    private @SignatureUnknown Path createWorkingDirectory(@SignatureUnknown String classname, @SignatureUnknown int pass) {
        try {
            Path workingDirectory = Files.createTempDirectory("check" + classname + pass, new FileAttribute[0]);
            return workingDirectory;
        }
        catch (IOException e) {
            System.err.printf("Unable to create temporary directory for flaky-test filtering, exception: %s%n", e.getMessage());
            System.exit(1);
            throw new Error("unreachable statement");
        }
    }

    private static class Match {
        final @SignatureUnknown String line;
        final @SignatureUnknown String group;

        Match(@SignatureUnknown String line, @SignatureUnknown String group) {
            this.line = line;
            this.group = group;
        }
    }

    private static class NotMatchedException
    extends RuntimeException {
        private static final @SignatureUnknown long serialVersionUID = 20171024L;
        public final @SignatureUnknown Pattern pattern;

        public NotMatchedException(@SignatureUnknown Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        @Pure
        public @SignatureUnknown String getMessage() {
            return "NotMatchedException(" + this.pattern + ")";
        }
    }
}

