/*
 * Decompiled with CFR 0.152.
 */
package randoop.output;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import randoop.com.github.javaparser.JavaParser;
import randoop.com.github.javaparser.ParseResult;
import randoop.com.github.javaparser.Problem;
import randoop.com.github.javaparser.ast.CompilationUnit;
import randoop.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import randoop.com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import randoop.main.Minimize;
import randoop.main.RandoopBug;
import randoop.main.RandoopUsageError;
import randoop.org.apache.commons.io.FilenameUtils;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class ClassRenamingVisitor
extends VoidVisitorAdapter<Void> {
    private final @SignatureUnknown String oldName;
    private final @SignatureUnknown String newName;
    private static final @SignatureUnknown JavaParser javaParser = new JavaParser();

    public ClassRenamingVisitor(@SignatureUnknown String oldName, @SignatureUnknown String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public void visit(@SignatureUnknown ClassOrInterfaceDeclaration n, @SignatureUnknown Void arg) {
        if (n.getName().toString().equals(this.oldName)) {
            n.setName(this.newName);
        }
    }

    public static @SignatureUnknown Path copyAndRename(@SignatureUnknown Path file, @SignatureUnknown String newClassName) {
        CompilationUnit compilationUnit;
        block9: {
            try (FileInputStream inputStream = new FileInputStream(file.toFile());){
                ParseResult<CompilationUnit> parseCompilationUnit = javaParser.parse(inputStream);
                if (parseCompilationUnit.isSuccessful()) {
                    compilationUnit = parseCompilationUnit.getResult().get();
                    break block9;
                }
                StringBuilder sb = new StringBuilder("Error parsing Java file: ");
                sb.append(file);
                for (Problem problem : parseCompilationUnit.getProblems()) {
                    sb.append(problem);
                }
                throw new RandoopBug(sb.toString());
            }
            catch (IOException e) {
                throw new RandoopBug("Error reading Java file: " + file, e);
            }
        }
        return ClassRenamingVisitor.copyAndRename(file, compilationUnit, FilenameUtils.removeExtension(file.getFileName().toString()), newClassName);
    }

    public static @SignatureUnknown Path copyAndRename(@SignatureUnknown Path file, @SignatureUnknown CompilationUnit compilationUnit, @SignatureUnknown String oldClassName, @SignatureUnknown String newClassName) {
        new ClassRenamingVisitor(oldClassName, newClassName).visit(compilationUnit, null);
        Path minimizedFile = file.resolveSibling(newClassName + ".java");
        try {
            Minimize.writeToFile(compilationUnit, minimizedFile);
        }
        catch (IOException e) {
            throw new RandoopUsageError("Problem while writing file " + minimizedFile, e);
        }
        return minimizedFile;
    }
}

