/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.plumelib.util;

import java.lang.ref.WeakReference;
import randoop.org.checkerframework.checker.formatter.qual.FormatBottom;
import randoop.org.checkerframework.checker.formatter.qual.UnknownFormat;
import randoop.org.checkerframework.checker.index.qual.LessThanUnknown;
import randoop.org.checkerframework.checker.index.qual.LowerBoundUnknown;
import randoop.org.checkerframework.checker.index.qual.SameLenUnknown;
import randoop.org.checkerframework.checker.index.qual.SearchIndexUnknown;
import randoop.org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import randoop.org.checkerframework.checker.index.qual.UpperBoundUnknown;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.lock.qual.GuardSatisfied;
import randoop.org.checkerframework.checker.lock.qual.GuardedBy;
import randoop.org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class WeakIdentityPair<@FormatBottom T1, @FormatBottom T2> {
    private final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown WeakReference<T1> a;
    private final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown WeakReference<T2> b;
    private final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown int hashCode;

    public WeakIdentityPair(T1 a, T2 b) {
        int hashCodeB;
        int hashCodeA;
        if (a == null || b == null) {
            throw new IllegalArgumentException(String.format("WeakIdentityPair cannot hold null: %s %s", a, b));
        }
        this.a = new WeakReference<T1>(a);
        this.b = new WeakReference<T2>(b);
        try {
            hashCodeA = a.hashCode();
        }
        catch (StackOverflowError e) {
            hashCodeA = 0;
        }
        try {
            hashCodeB = b.hashCode();
        }
        catch (StackOverflowError e) {
            hashCodeB = 0;
        }
        this.hashCode = hashCodeA + hashCodeB;
    }

    public static <A, B> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown WeakIdentityPair<A, B> of(A a, B b) {
        return new WeakIdentityPair<A, B>(a, b);
    }

    @SideEffectFree
    public @Nullable T1 getA(@GuardSatisfied WeakIdentityPair<T1, T2> this) {
        return (T1)this.a.get();
    }

    @SideEffectFree
    public @Nullable T2 getB(@GuardSatisfied WeakIdentityPair<T1, T2> this) {
        return (T2)this.b.get();
    }

    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String toString(@GuardSatisfied WeakIdentityPair<T1, T2> this) {
        return "<" + String.valueOf(this.a) + "," + String.valueOf(this.b) + ">";
    }

    @SideEffectFree
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean equals(@GuardSatisfied WeakIdentityPair<T1, T2> this, @GuardSatisfied @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown Object obj) {
        if (!(obj instanceof WeakIdentityPair)) {
            return false;
        }
        WeakIdentityPair other = (WeakIdentityPair)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        @Nullable T1 a = this.getA();
        @Nullable T2 b = this.getB();
        @Nullable T1 oa = other.getA();
        @Nullable T2 ob = other.getB();
        if (a == null || b == null || oa == null || ob == null) {
            return false;
        }
        return a == oa && b == ob;
    }

    @Pure
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown int hashCode(@GuardSatisfied WeakIdentityPair<T1, T2> this) {
        return this.hashCode;
    }
}

