/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.plumelib.reflection;

import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import randoop.org.checkerframework.checker.formatter.qual.UnknownFormat;
import randoop.org.checkerframework.checker.index.qual.IndexFor;
import randoop.org.checkerframework.checker.index.qual.LessThanUnknown;
import randoop.org.checkerframework.checker.index.qual.LowerBoundUnknown;
import randoop.org.checkerframework.checker.index.qual.Positive;
import randoop.org.checkerframework.checker.index.qual.SameLenUnknown;
import randoop.org.checkerframework.checker.index.qual.SearchIndexUnknown;
import randoop.org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import randoop.org.checkerframework.checker.index.qual.UpperBoundUnknown;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.lock.qual.GuardedBy;
import randoop.org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.ArrayWithoutPackage;
import randoop.org.checkerframework.checker.signature.qual.BinaryName;
import randoop.org.checkerframework.checker.signature.qual.BinaryNameOrPrimitiveType;
import randoop.org.checkerframework.checker.signature.qual.BinaryNameWithoutPackage;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.ClassGetSimpleName;
import randoop.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import randoop.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiersOrPrimitiveType;
import randoop.org.checkerframework.checker.signature.qual.FieldDescriptor;
import randoop.org.checkerframework.checker.signature.qual.FieldDescriptorForPrimitive;
import randoop.org.checkerframework.checker.signature.qual.FieldDescriptorWithoutPackage;
import randoop.org.checkerframework.checker.signature.qual.FqBinaryName;
import randoop.org.checkerframework.checker.signature.qual.FullyQualifiedName;
import randoop.org.checkerframework.checker.signature.qual.Identifier;
import randoop.org.checkerframework.checker.signature.qual.IdentifierOrPrimitiveType;
import randoop.org.checkerframework.checker.signature.qual.InternalForm;
import randoop.org.checkerframework.checker.signature.qual.PrimitiveType;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.framework.qual.EnsuresQualifierIf;
import randoop.org.plumelib.reflection.SignatureRegexes;

public final class Signatures {
    private static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String dirSep = File.separator;
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown Pattern arrayBracketsPattern = Pattern.compile("(\\[\\])+$");
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown HashMap<@PrimitiveType @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex String, @FieldDescriptor @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex String> primitiveToFieldDescriptor = new HashMap(8);
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown HashMap<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String> fieldDescriptorToPrimitive;
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown Pattern fdArrayBracketsPattern;

    public static @ClassGetName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String getArrayElementType(@FqBinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String fqBinaryName) {
        int bracketPos = fqBinaryName.indexOf(91);
        if (bracketPos == -1) {
            return fqBinaryName;
        }
        return fqBinaryName.substring(0, bracketPos);
    }

    public static @BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String classfilenameToBinaryName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String classfilename) {
        if (!classfilename.endsWith(".class")) {
            throw new IllegalArgumentException("Bad class file name: " + classfilename);
        }
        if ((classfilename = classfilename.substring(0, classfilename.length() - 6)).startsWith("/") || classfilename.startsWith(dirSep)) {
            classfilename = classfilename.substring(1);
        }
        return classfilename.replace("/", ".").replace(dirSep, ".");
    }

    public static @BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String classfilenameToBaseName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String classfilename) {
        if (!classfilename.endsWith(".class")) {
            throw new IllegalArgumentException("Bad class file name: " + classfilename);
        }
        @IndexFor(value={"classfilename"}) int start = classfilename.lastIndexOf("/") + 1;
        int end = classfilename.length() - 6;
        return classfilename.substring(start, end);
    }

    public static @BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String addPackage(@Nullable @DotSeparatedIdentifiers @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @UnknownRegex String packagename, @BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String classname) {
        if (!Signatures.isBinaryName(classname)) {
            throw new Error("Bad classname argument to addPackage: " + classname);
        }
        if (packagename == null) {
            return classname;
        }
        if (!Signatures.isDotSeparatedIdentifiers(packagename)) {
            throw new Error("Bad packagename argument to addPackage: " + packagename);
        }
        @BinaryName String result = packagename + "." + classname;
        return result;
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=ArrayWithoutPackage.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isArrayWithoutPackage(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.ArrayWithoutPackagePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=BinaryName.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isBinaryName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.BinaryNamePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=BinaryNameWithoutPackage.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isBinaryNameWithoutPackage(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.BinaryNameWithoutPackagePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=BinaryNameOrPrimitiveType.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isBinaryNameOrPrimitiveType(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.BinaryNameOrPrimitiveTypePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=ClassGetName.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isClassGetName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.ClassGetNamePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=ClassGetSimpleName.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isClassGetSimpleName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.ClassGetSimpleNamePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=DotSeparatedIdentifiers.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isDotSeparatedIdentifiers(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.DotSeparatedIdentifiersPattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=DotSeparatedIdentifiersOrPrimitiveType.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isDotSeparatedIdentifiersOrPrimitiveType(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.DotSeparatedIdentifiersOrPrimitiveTypePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=FieldDescriptor.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isFieldDescriptor(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.FieldDescriptorPattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=FieldDescriptorWithoutPackage.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isFieldDescriptorWithoutPackage(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.FieldDescriptorWithoutPackagePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=FieldDescriptorForPrimitive.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isFieldDescriptorForPrimitive(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.FieldDescriptorForPrimitivePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=FqBinaryName.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isFqBinaryName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.FqBinaryNamePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=FullyQualifiedName.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isFullyQualifiedName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.FullyQualifiedNamePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Identifier.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isIdentifier(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.IdentifierPattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=IdentifierOrPrimitiveType.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isIdentifierOrPrimitiveType(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.IdentifierOrPrimitiveTypePattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=InternalForm.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isInternalForm(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.InternalFormPattern.matcher(s2).matches();
    }

    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=PrimitiveType.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean isPrimitiveType(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String s2) {
        return SignatureRegexes.PrimitiveTypePattern.matcher(s2).matches();
    }

    public static @FieldDescriptor @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String binaryNameToFieldDescriptor(@FqBinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String typename) {
        ClassnameAndDimensions cad = ClassnameAndDimensions.parseFqBinaryName(typename);
        String result = primitiveToFieldDescriptor.get(cad.classname);
        if (result == null) {
            result = "L" + cad.classname + ";";
        }
        for (int i = 0; i < cad.dimensions; ++i) {
            result = "[" + result;
        }
        return result.replace('.', '/');
    }

    public static @FieldDescriptor @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String primitiveTypeNameToFieldDescriptor(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String primitiveName) {
        String result = primitiveToFieldDescriptor.get(primitiveName);
        if (result == null) {
            throw new IllegalArgumentException("Not the name of a primitive type: " + primitiveName);
        }
        return result;
    }

    public static @ClassGetName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String binaryNameToClassGetName(@BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String bn) {
        if (bn.endsWith("[]")) {
            return Signatures.binaryNameToFieldDescriptor(bn).replace('/', '.');
        }
        return bn;
    }

    public static @FullyQualifiedName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String binaryNameToFullyQualified(@BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String binaryName) {
        return binaryName.replaceAll("\\$", ".");
    }

    public static @ClassGetName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String fieldDescriptorToClassGetName(@FieldDescriptor @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String fd) {
        if (fd.startsWith("[")) {
            return fd.replace('/', '.');
        }
        return Signatures.fieldDescriptorToBinaryName(fd);
    }

    public static @BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String fieldDescriptorToBinaryName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String typename) {
        String result;
        if (typename.equals("")) {
            throw new Error("Empty string passed to fieldDescriptorToBinaryName");
        }
        Matcher m3 = fdArrayBracketsPattern.matcher(typename);
        String classname = m3.replaceFirst("");
        int dimensions = typename.length() - classname.length();
        if (classname.startsWith("L") && classname.endsWith(";")) {
            result = classname.substring(1, classname.length() - 1);
        } else {
            result = fieldDescriptorToPrimitive.get(classname);
            if (result == null) {
                throw new Error("Malformed base class: " + classname);
            }
        }
        for (int i = 0; i < dimensions; ++i) {
            result = result + "[]";
        }
        return result.replace('/', '.');
    }

    public static @ClassGetName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String internalFormToClassGetName(@InternalForm @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String internalForm) {
        return internalForm.replace('/', '.');
    }

    public static @BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String internalFormToBinaryName(@InternalForm @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String internalForm) {
        return internalForm.replace('/', '.');
    }

    public static @FullyQualifiedName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String internalFormToFullyQualified(@InternalForm @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String internalForm) {
        return Signatures.binaryNameToFullyQualified(Signatures.internalFormToBinaryName(internalForm));
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String arglistToJvm(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String arglist) {
        if (!arglist.startsWith("(") || !arglist.endsWith(")")) {
            throw new Error("Malformed arglist: " + arglist);
        }
        String result = "(";
        String commaSepArgs = arglist.substring(1, arglist.length() - 1);
        StringTokenizer argsTokenizer = new StringTokenizer(commaSepArgs, ",", false);
        while (argsTokenizer.hasMoreTokens()) {
            @BinaryName String arg = argsTokenizer.nextToken().trim();
            result = result + Signatures.binaryNameToFieldDescriptor(arg);
        }
        result = result + ")";
        return result;
    }

    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String arglistFromJvm(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String arglist) {
        if (!arglist.startsWith("(") || !arglist.endsWith(")")) {
            throw new Error("Malformed arglist: " + arglist);
        }
        String result = "(";
        @Positive int pos = 1;
        while (pos < arglist.length() - 1) {
            if (pos > 1) {
                result = result + ", ";
            }
            int nonarrayPos = pos;
            while (arglist.charAt(nonarrayPos) == '[') {
                if (++nonarrayPos < arglist.length()) continue;
                throw new Error("Malformed arglist: " + arglist);
            }
            char c = arglist.charAt(nonarrayPos);
            if (c == 'L') {
                int semicolonPos = arglist.indexOf(59, nonarrayPos);
                if (semicolonPos == -1) {
                    throw new Error("Malformed arglist: " + arglist);
                }
                String fieldDescriptor = arglist.substring(pos, semicolonPos + 1);
                result = result + Signatures.fieldDescriptorToBinaryName(fieldDescriptor);
                pos = semicolonPos + 1;
                continue;
            }
            String maybe = Signatures.fieldDescriptorToBinaryName(arglist.substring(pos, nonarrayPos + 1));
            if (maybe == null) {
                throw new Error("Malformed arglist: " + arglist);
            }
            result = result + maybe;
            pos = nonarrayPos + 1;
        }
        return result + ")";
    }

    static {
        primitiveToFieldDescriptor.put("boolean", "Z");
        primitiveToFieldDescriptor.put("byte", "B");
        primitiveToFieldDescriptor.put("char", "C");
        primitiveToFieldDescriptor.put("double", "D");
        primitiveToFieldDescriptor.put("float", "F");
        primitiveToFieldDescriptor.put("int", "I");
        primitiveToFieldDescriptor.put("long", "J");
        primitiveToFieldDescriptor.put("short", "S");
        fieldDescriptorToPrimitive = new HashMap(8);
        fieldDescriptorToPrimitive.put("Z", "boolean");
        fieldDescriptorToPrimitive.put("B", "byte");
        fieldDescriptorToPrimitive.put("C", "char");
        fieldDescriptorToPrimitive.put("D", "double");
        fieldDescriptorToPrimitive.put("F", "float");
        fieldDescriptorToPrimitive.put("I", "int");
        fieldDescriptorToPrimitive.put("J", "long");
        fieldDescriptorToPrimitive.put("S", "short");
        fdArrayBracketsPattern = Pattern.compile("^\\[+");
    }

    public static class ClassnameAndDimensions {
        public final @BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex String classname;
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown int dimensions;

        public ClassnameAndDimensions(@BinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String classname, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown int dimensions) {
            this.classname = classname;
            this.dimensions = dimensions;
        }

        public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown ClassnameAndDimensions parseFqBinaryName(@FqBinaryName @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex String typename) {
            Matcher m3 = arrayBracketsPattern.matcher(typename);
            @BinaryName String classname = m3.replaceFirst("");
            int dimensions = (typename.length() - classname.length()) / 2;
            return new ClassnameAndDimensions(classname, dimensions);
        }
    }
}

