/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.plumelib.bcelutil;

import java.util.Arrays;
import randoop.org.apache.bcel.classfile.StackMapEntry;
import randoop.org.apache.bcel.classfile.StackMapType;
import randoop.org.apache.bcel.generic.BranchInstruction;
import randoop.org.apache.bcel.generic.CodeExceptionGen;
import randoop.org.apache.bcel.generic.IfInstruction;
import randoop.org.apache.bcel.generic.Instruction;
import randoop.org.apache.bcel.generic.InstructionFactory;
import randoop.org.apache.bcel.generic.InstructionHandle;
import randoop.org.apache.bcel.generic.InstructionList;
import randoop.org.apache.bcel.generic.InstructionTargeter;
import randoop.org.apache.bcel.generic.LOOKUPSWITCH;
import randoop.org.apache.bcel.generic.LineNumberGen;
import randoop.org.apache.bcel.generic.LocalVariableGen;
import randoop.org.apache.bcel.generic.MethodGen;
import randoop.org.apache.bcel.generic.TABLESWITCH;
import randoop.org.apache.bcel.verifier.structurals.OperandStack;
import randoop.org.checkerframework.checker.formatter.qual.UnknownFormat;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.lock.qual.GuardedBy;
import randoop.org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.bcelutil.StackMapUtils;
import randoop.org.plumelib.bcelutil.StackTypes;

public abstract class InstructionListUtils
extends StackMapUtils {
    protected final void append_inst(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionList il, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown Instruction inst) {
        if (inst instanceof LOOKUPSWITCH) {
            LOOKUPSWITCH ls = (LOOKUPSWITCH)inst;
            il.append(new LOOKUPSWITCH(ls.getMatchs(), ls.getTargets(), ls.getTarget()));
        } else if (inst instanceof TABLESWITCH) {
            TABLESWITCH ts = (TABLESWITCH)inst;
            il.append(new TABLESWITCH(ts.getMatchs(), ts.getTargets(), ts.getTarget()));
        } else if (inst instanceof IfInstruction) {
            IfInstruction ifi = (IfInstruction)inst;
            il.append(InstructionFactory.createBranchInstruction(inst.getOpcode(), ifi.getTarget()));
        } else {
            il.append(inst);
        }
    }

    protected final void insert_at_method_start(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionList new_il) {
        InstructionList il = mg.getInstructionList();
        if (il == null) {
            return;
        }
        this.insert_before_handle(mg, il.getStart(), new_il, false);
    }

    protected final void insert_before_handle(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionHandle ih, @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown InstructionList new_il, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown boolean redirect_branches) {
        if (new_il == null) {
            return;
        }
        InstructionList il = mg.getInstructionList();
        if (il == null) {
            return;
        }
        boolean at_start = ih.getPrev() == null;
        new_il.setPositions();
        InstructionHandle new_end = new_il.getEnd();
        int new_length = new_end.getPosition() + new_end.getInstruction().getLength();
        this.print_stack_map_table("Before insert_inst");
        this.debug_instrument.log("  insert_inst: %d%n%s%n", new_il.getLength(), new_il);
        InstructionHandle new_start = il.insert(ih, new_il);
        il.setPositions();
        if (redirect_branches) {
            il.redirectBranches(ih, new_start);
        }
        if (ih.hasTargeters()) {
            for (InstructionTargeter it : ih.getTargeters()) {
                if (it instanceof LineNumberGen && redirect_branches) {
                    it.updateTarget(ih, new_start);
                    continue;
                }
                if (it instanceof LocalVariableGen) {
                    LocalVariableGen lvg = (LocalVariableGen)it;
                    if (lvg.getStart() != ih || !at_start) continue;
                    it.updateTarget(ih, new_start);
                    continue;
                }
                if (!(it instanceof CodeExceptionGen) || !redirect_branches) continue;
                CodeExceptionGen exc = (CodeExceptionGen)it;
                if (exc.getStartPC() == ih) {
                    exc.updateTarget(ih, new_start);
                    continue;
                }
                if (exc.getHandlerPC() == ih) {
                    exc.setHandlerPC(new_start);
                    continue;
                }
                System.out.printf("Malformed CodeException: %s%n", exc);
            }
        }
        il.setPositions();
        this.update_stack_map_offset(new_start.getPosition() - (redirect_branches ? 0 : 1), new_length);
        this.print_il(new_start, "After update_stack_map_offset");
        this.modify_stack_maps_for_switches(new_start, il);
    }

    private void print_il(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionHandle start, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown String label) {
        if (this.debug_instrument.enabled()) {
            this.print_stack_map_table(label);
            for (InstructionHandle tih = start; tih != null; tih = tih.getNext()) {
                this.debug_instrument.log("inst: %s %n", tih);
                if (!tih.hasTargeters()) continue;
                for (InstructionTargeter it : tih.getTargeters()) {
                    this.debug_instrument.log("targeter: %s %n", it);
                }
            }
        }
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionList build_il(Instruction ... instructions) {
        InstructionList il = new InstructionList();
        for (Instruction inst : instructions) {
            this.append_inst(il, inst);
        }
        return il;
    }

    protected final void delete_instructions(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionHandle start_ih, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionHandle end_ih) {
        InstructionList il = mg.getInstructionList();
        InstructionHandle new_start = end_ih.getNext();
        if (new_start == null) {
            throw new RuntimeException("Cannot delete last instruction.");
        }
        il.setPositions();
        int size_deletion = start_ih.getPosition() - new_start.getPosition();
        il.redirectBranches(start_ih, new_start);
        if (start_ih.hasTargeters()) {
            for (InstructionTargeter it : start_ih.getTargeters()) {
                if (it instanceof LineNumberGen) {
                    it.updateTarget(start_ih, new_start);
                    continue;
                }
                if (it instanceof LocalVariableGen) {
                    it.updateTarget(start_ih, new_start);
                    continue;
                }
                if (it instanceof CodeExceptionGen) {
                    CodeExceptionGen exc = (CodeExceptionGen)it;
                    if (exc.getStartPC() == start_ih) {
                        exc.updateTarget(start_ih, new_start);
                        continue;
                    }
                    if (exc.getEndPC() == start_ih) {
                        exc.updateTarget(start_ih, new_start);
                        continue;
                    }
                    if (exc.getHandlerPC() == start_ih) {
                        exc.setHandlerPC(new_start);
                        continue;
                    }
                    System.out.printf("Malformed CodeException: %s%n", exc);
                    continue;
                }
                System.out.printf("unexpected target %s%n", it);
            }
        }
        try {
            il.delete(start_ih, end_ih);
        }
        catch (Exception e) {
            throw new Error("Can't delete instruction list", e);
        }
        il.setPositions();
        this.update_stack_map_offset(new_start.getPosition(), size_deletion);
        this.modify_stack_maps_for_switches(new_start, il);
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown StackMapType @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown [] calculate_live_local_types(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown MethodGen mg, @UnknownFormat @Interned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown int location) {
        int max_local_index = -1;
        Object[] local_map_types = new StackMapType[mg.getMaxLocals()];
        Arrays.fill(local_map_types, new StackMapType(0, -1, this.pool.getConstantPool()));
        for (LocalVariableGen lv : mg.getLocalVariables()) {
            if (location < lv.getStart().getPosition() || !lv.getLiveToEnd() && location >= lv.getEnd().getPosition()) continue;
            int i = lv.getIndex();
            local_map_types[i] = this.generate_StackMapType_from_Type(lv.getType());
            max_local_index = Math.max(max_local_index, i);
        }
        return (StackMapType[])Arrays.copyOf(local_map_types, max_local_index + 1);
    }

    protected final @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown StackMapType @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown [] calculate_live_stack_types(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown OperandStack stack) {
        int ss = stack.size();
        StackMapType[] stack_map_types = new StackMapType[ss];
        for (int ii = 0; ii < ss; ++ii) {
            stack_map_types[ii] = this.generate_StackMapType_from_Type(stack.peek(ss - ii - 1));
        }
        return stack_map_types;
    }

    protected final void replace_instructions(@UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown MethodGen mg, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionList il, @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown InstructionHandle ih, @Nullable @UnknownFormat @UnknownInterned @LockPossiblyHeld @GuardedBy @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown InstructionList new_il) {
        InstructionHandle new_end;
        if (new_il == null) {
            return;
        }
        int old_length = ih.getInstruction().getLength();
        new_il.setPositions();
        InstructionHandle end = new_il.getEnd();
        int new_length = end.getPosition() + end.getInstruction().getLength();
        this.debug_instrument.log("  replace_inst: %s %d%n%s%n", ih, new_il.getLength(), new_il);
        this.print_il(ih, "Before replace_inst");
        if (new_il.getLength() == 1) {
            ih.setInstruction(new_il.getEnd().getInstruction());
            if (old_length == new_length) {
                return;
            }
            this.print_stack_map_table("replace_inst_with_single_inst B");
            il.setPositions();
            new_end = ih;
            this.update_stack_map_offset(ih.getPosition(), new_length - old_length);
            this.modify_stack_maps_for_switches(new_end, il);
        } else {
            this.print_stack_map_table("replace_inst_with_inst_list B");
            new_end = new_il.getEnd();
            InstructionHandle new_start = il.insert(ih, new_il);
            il.setPositions();
            new_length = new_end.getNext().getPosition() - new_start.getPosition();
            il.redirectBranches(ih, new_start);
            this.print_il(new_end, "replace_inst #1");
            if (ih.hasTargeters()) {
                for (InstructionTargeter instructionTargeter : ih.getTargeters()) {
                    if (instructionTargeter instanceof LineNumberGen) {
                        instructionTargeter.updateTarget(ih, new_start);
                        continue;
                    }
                    if (instructionTargeter instanceof LocalVariableGen) {
                        instructionTargeter.updateTarget(ih, new_end);
                        continue;
                    }
                    if (instructionTargeter instanceof CodeExceptionGen) {
                        CodeExceptionGen exc = (CodeExceptionGen)instructionTargeter;
                        if (exc.getStartPC() == ih) {
                            exc.updateTarget(ih, new_start);
                            continue;
                        }
                        if (exc.getEndPC() == ih) {
                            exc.updateTarget(ih, new_end);
                            continue;
                        }
                        if (exc.getHandlerPC() == ih) {
                            exc.setHandlerPC(new_start);
                            continue;
                        }
                        System.out.printf("Malformed CodeException: %s%n", exc);
                        continue;
                    }
                    System.out.printf("unexpected target %s%n", instructionTargeter);
                }
            }
            this.print_il(new_end, "replace_inst #2");
            try {
                il.delete(ih);
            }
            catch (Exception e) {
                System.out.printf("Can't delete instruction: %s at %s%n", mg.getClassName(), mg.getName());
                throw new Error("Can't delete instruction", e);
            }
            il.setPositions();
            this.print_il(new_end, "replace_inst #3");
            if (this.needStackMap) {
                this.update_stack_map_offset(new_start.getPosition(), new_length - old_length);
                this.modify_stack_maps_for_switches(new_end, il);
                this.print_stack_map_table("replace_inst_with_inst_list C");
                InstructionHandle nih = new_start;
                int target_count = 0;
                int[] target_offsets = new int[2];
                new_end = new_end.getNext();
                for (nih = nih.getNext(); nih != new_end; nih = nih.getNext()) {
                    if (!nih.hasTargeters()) continue;
                    for (InstructionTargeter it : nih.getTargeters()) {
                        if (!(it instanceof BranchInstruction)) continue;
                        target_offsets[target_count++] = nih.getPosition();
                        this.debug_instrument.log("New branch target: %s %n", nih);
                    }
                }
                this.print_il(new_end, "replace_inst #4");
                if (target_count != 0) {
                    OperandStack stack;
                    int n = new_start.getPosition();
                    int orig_size = this.stack_map_table.length;
                    StackMapEntry[] new_stack_map_table = new StackMapEntry[orig_size + target_count];
                    mg.setMaxStack();
                    StackTypes stack_types = this.bcel_calc_stack_types(mg);
                    if (stack_types == null) {
                        Error e = new Error(String.format("bcel_calc_stack_types failure in %s.%s%n", mg.getClassName(), mg.getName()));
                        e.printStackTrace();
                        throw e;
                    }
                    int new_index = this.find_stack_map_index_before(target_offsets[0]) + 1;
                    StackMapType[] local_map_types = this.calculate_live_local_types(mg, n);
                    int local_map_index = local_map_types.length;
                    int number_extra_locals = local_map_index - this.number_active_locals;
                    assert (number_extra_locals >= 0) : "invalid extra locals count: " + this.number_active_locals + ", " + local_map_index;
                    System.arraycopy(this.stack_map_table, 0, new_stack_map_table, 0, new_index);
                    boolean need_full_maps = false;
                    for (int i = 0; i < target_count; ++i) {
                        stack = stack_types.get(target_offsets[i]);
                        this.debug_instrument.log("stack: %s %n", stack);
                        if (number_extra_locals == 0 && stack.size() == 1 && !need_full_maps) {
                            StackMapType stackMapType = this.generate_StackMapType_from_Type(stack.peek(0));
                            StackMapType[] stack_map_types0 = new StackMapType[]{stackMapType};
                            new_stack_map_table[new_index + i] = new StackMapEntry(64, 0, null, stack_map_types0, this.pool.getConstantPool());
                        } else {
                            need_full_maps = true;
                            new_stack_map_table[new_index + i] = new StackMapEntry(255, 0, this.calculate_live_local_types(mg, target_offsets[i]), this.calculate_live_stack_types(stack), this.pool.getConstantPool());
                        }
                        new_stack_map_table[new_index + i].updateByteCodeOffset(target_offsets[i] - (this.running_offset + 1));
                        this.running_offset = target_offsets[i];
                    }
                    int remainder = orig_size - new_index;
                    if (remainder > 0) {
                        block6: while (nih != null) {
                            if (nih.hasTargeters()) {
                                for (InstructionTargeter it : nih.getTargeters()) {
                                    CodeExceptionGen exc;
                                    if (it instanceof BranchInstruction) {
                                        this.stack_map_table[new_index].updateByteCodeOffset(nih.getPosition() - target_offsets[target_count - 1] - 1 - this.stack_map_table[new_index].getByteCodeOffset());
                                        break block6;
                                    }
                                    if (!(it instanceof CodeExceptionGen) || (exc = (CodeExceptionGen)it).getHandlerPC() != nih) continue;
                                    this.stack_map_table[new_index].updateByteCodeOffset(nih.getPosition() - target_offsets[target_count - 1] - 1 - this.stack_map_table[new_index].getByteCodeOffset());
                                    break block6;
                                }
                            }
                            nih = nih.getNext();
                        }
                        if (need_full_maps) {
                            while (remainder > 0) {
                                int n2 = this.stack_map_table[new_index].getByteCodeOffset();
                                this.running_offset = this.running_offset + n2 + 1;
                                stack = stack_types.get(this.running_offset);
                                new_stack_map_table[new_index + target_count] = new StackMapEntry(255, n2, this.calculate_live_local_types(mg, this.running_offset), this.calculate_live_stack_types(stack), this.pool.getConstantPool());
                                ++new_index;
                                --remainder;
                            }
                        } else {
                            System.arraycopy(this.stack_map_table, new_index, new_stack_map_table, new_index + target_count, remainder);
                        }
                    }
                    this.stack_map_table = new_stack_map_table;
                }
            }
        }
        this.debug_instrument.log("%n", new Object[0]);
        this.print_il(new_end, "replace_inst #5");
    }
}

