/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WriterOutputStream
extends OutputStream {
    private static final @UnknownKeyFor @NonNull @Initialized int BUFFER_SIZE = 1024;
    private final @UnknownKeyFor @NonNull @Initialized Writer writer;
    private final @UnknownKeyFor @NonNull @Initialized CharsetDecoder decoder;
    private final @UnknownKeyFor @NonNull @Initialized boolean writeImmediately;
    private final @UnknownKeyFor @NonNull @Initialized ByteBuffer decoderIn = ByteBuffer.allocate(128);
    private final @UnknownKeyFor @NonNull @Initialized CharBuffer decoderOut;

    public WriterOutputStream(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized CharsetDecoder decoder) {
        this(writer, decoder, 1024, false);
    }

    public WriterOutputStream(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized CharsetDecoder decoder, @UnknownKeyFor @NonNull @Initialized int bufferSize, @UnknownKeyFor @NonNull @Initialized boolean writeImmediately) {
        WriterOutputStream.checkIbmJdkWithBrokenUTF16(decoder.charset());
        this.writer = writer;
        this.decoder = decoder;
        this.writeImmediately = writeImmediately;
        this.decoderOut = CharBuffer.allocate(bufferSize);
    }

    public WriterOutputStream(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized Charset charset, @UnknownKeyFor @NonNull @Initialized int bufferSize, @UnknownKeyFor @NonNull @Initialized boolean writeImmediately) {
        this(writer, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?"), bufferSize, writeImmediately);
    }

    public WriterOutputStream(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized Charset charset) {
        this(writer, charset, 1024, false);
    }

    public WriterOutputStream(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized String charsetName, @UnknownKeyFor @NonNull @Initialized int bufferSize, @UnknownKeyFor @NonNull @Initialized boolean writeImmediately) {
        this(writer, Charset.forName(charsetName), bufferSize, writeImmediately);
    }

    public WriterOutputStream(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized String charsetName) {
        this(writer, charsetName, 1024, false);
    }

    @Deprecated
    public WriterOutputStream(@UnknownKeyFor @NonNull @Initialized Writer writer) {
        this(writer, Charset.defaultCharset(), 1024, false);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        while (len > 0) {
            int c = Math.min(len, this.decoderIn.remaining());
            this.decoderIn.put(b, off, c);
            this.processInput(false);
            len -= c;
            off += c;
        }
        if (this.writeImmediately) {
            this.flushOutput();
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.flushOutput();
        this.writer.flush();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.processInput(true);
        this.flushOutput();
        this.writer.close();
    }

    private void processInput(@UnknownKeyFor @NonNull @Initialized boolean endOfInput) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CoderResult coderResult;
        this.decoderIn.flip();
        while ((coderResult = this.decoder.decode(this.decoderIn, this.decoderOut, endOfInput)).isOverflow()) {
            this.flushOutput();
        }
        if (!coderResult.isUnderflow()) {
            throw new IOException("Unexpected coder result");
        }
        this.decoderIn.compact();
    }

    private void flushOutput() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.decoderOut.position() > 0) {
            this.writer.write(this.decoderOut.array(), 0, this.decoderOut.position());
            this.decoderOut.rewind();
        }
    }

    private static void checkIbmJdkWithBrokenUTF16(@UnknownKeyFor @NonNull @Initialized Charset charset) {
        if (!"UTF-16".equals(charset.name())) {
            return;
        }
        String TEST_STRING_2 = "v\u00e9s";
        byte[] bytes = "v\u00e9s".getBytes(charset);
        CharsetDecoder charsetDecoder2 = charset.newDecoder();
        ByteBuffer bb2 = ByteBuffer.allocate(16);
        CharBuffer cb2 = CharBuffer.allocate("v\u00e9s".length());
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            bb2.put(bytes[i]);
            bb2.flip();
            try {
                charsetDecoder2.decode(bb2, cb2, i == len - 1);
            }
            catch (IllegalArgumentException e) {
                throw new UnsupportedOperationException("UTF-16 requested when runninng on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UF-16 with WriterOutputStream");
            }
            bb2.compact();
        }
        cb2.rewind();
        if (!"v\u00e9s".equals(cb2.toString())) {
            throw new UnsupportedOperationException("UTF-16 requested when runninng on an IBM JDK with broken UTF-16 support. Please find a JDK that supports UTF-16 if you intend to use UF-16 with WriterOutputStream");
        }
    }
}

