/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import randoop.org.apache.commons.io.TaggedIOException;
import randoop.org.apache.commons.io.output.ProxyOutputStream;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TaggedOutputStream
extends ProxyOutputStream {
    private final @UnknownKeyFor @NonNull @Initialized Serializable tag = UUID.randomUUID();

    public TaggedOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream proxy) {
        super(proxy);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCauseOf(@UnknownKeyFor @NonNull @Initialized Exception exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(@UnknownKeyFor @NonNull @Initialized Exception exception) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TaggedIOException.throwCauseIfTaggedWith(exception, this.tag);
    }

    @Override
    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new TaggedIOException(e, this.tag);
    }
}

