/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.output;

import java.io.OutputStream;
import randoop.org.apache.commons.io.output.ProxyOutputStream;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CountingOutputStream
extends ProxyOutputStream {
    private @UnknownKeyFor @NonNull @Initialized long count = 0L;

    public CountingOutputStream(@UnknownKeyFor @NonNull @Initialized OutputStream out) {
        super(out);
    }

    @Override
    protected synchronized void beforeWrite(@UnknownKeyFor @NonNull @Initialized int n) {
        this.count += (long)n;
    }

    public @UnknownKeyFor @NonNull @Initialized int getCount() {
        long result = this.getByteCount();
        if (result > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + result + " is too large to be converted to an int");
        }
        return (int)result;
    }

    public @UnknownKeyFor @NonNull @Initialized int resetCount() {
        long result = this.resetByteCount();
        if (result > Integer.MAX_VALUE) {
            throw new ArithmeticException("The byte count " + result + " is too large to be converted to an int");
        }
        return (int)result;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long getByteCount() {
        return this.count;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized long resetByteCount() {
        long tmp = this.count;
        this.count = 0L;
        return tmp;
    }
}

