/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WindowsLineEndingInputStream
extends InputStream {
    private @UnknownKeyFor @NonNull @Initialized boolean slashRSeen = false;
    private @UnknownKeyFor @NonNull @Initialized boolean slashNSeen = false;
    private @UnknownKeyFor @NonNull @Initialized boolean injectSlashN = false;
    private @UnknownKeyFor @NonNull @Initialized boolean eofSeen = false;
    private final @UnknownKeyFor @NonNull @Initialized InputStream target;
    private final @UnknownKeyFor @NonNull @Initialized boolean ensureLineFeedAtEndOfFile;

    public WindowsLineEndingInputStream(@UnknownKeyFor @NonNull @Initialized InputStream in, @UnknownKeyFor @NonNull @Initialized boolean ensureLineFeedAtEndOfFile) {
        this.target = in;
        this.ensureLineFeedAtEndOfFile = ensureLineFeedAtEndOfFile;
    }

    private @UnknownKeyFor @NonNull @Initialized int readWithUpdate() throws @UnknownKeyFor @NonNull @Initialized IOException {
        int target = this.target.read();
        boolean bl = this.eofSeen = target == -1;
        if (this.eofSeen) {
            return target;
        }
        this.slashRSeen = target == 13;
        this.slashNSeen = target == 10;
        return target;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.eofSeen) {
            return this.eofGame();
        }
        if (this.injectSlashN) {
            this.injectSlashN = false;
            return 10;
        }
        boolean prevWasSlashR = this.slashRSeen;
        int target = this.readWithUpdate();
        if (this.eofSeen) {
            return this.eofGame();
        }
        if (target == 10 && !prevWasSlashR) {
            this.injectSlashN = true;
            return 13;
        }
        return target;
    }

    private @UnknownKeyFor @NonNull @Initialized int eofGame() {
        if (!this.ensureLineFeedAtEndOfFile) {
            return -1;
        }
        if (!this.slashNSeen && !this.slashRSeen) {
            this.slashRSeen = true;
            return 13;
        }
        if (!this.slashNSeen) {
            this.slashRSeen = false;
            this.slashNSeen = true;
            return 10;
        }
        return -1;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        super.close();
        this.target.close();
    }

    @Override
    public synchronized void mark(@UnknownKeyFor @NonNull @Initialized int readlimit) {
        throw new UnsupportedOperationException("Mark not supported");
    }
}

