/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import randoop.org.apache.commons.io.IOUtils;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class ProxyReader
extends FilterReader {
    public ProxyReader(@UnknownKeyFor @NonNull @Initialized Reader proxy) {
        super(proxy);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeRead(1);
            int c = this.in.read();
            this.afterRead(c != -1 ? 1 : -1);
            return c;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeRead(IOUtils.length(chr));
            int n = this.in.read(chr);
            this.afterRead(n);
            return n;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] chr, @UnknownKeyFor @NonNull @Initialized int st, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeRead(len);
            int n = this.in.read(chr, st, len);
            this.afterRead(n);
            return n;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized CharBuffer target) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeRead(IOUtils.length(target));
            int n = this.in.read(target);
            this.afterRead(n);
            return n;
        }
        catch (IOException e) {
            this.handleIOException(e);
            return -1;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized long ln) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return this.in.skip(ln);
        }
        catch (IOException e) {
            this.handleIOException(e);
            return 0L;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean ready() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            return this.in.ready();
        }
        catch (IOException e) {
            this.handleIOException(e);
            return false;
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.in.close();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public synchronized void mark(@UnknownKeyFor @NonNull @Initialized int idx) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.in.mark(idx);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public synchronized void reset() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.in.reset();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean markSupported() {
        return this.in.markSupported();
    }

    protected void beforeRead(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void afterRead(@UnknownKeyFor @NonNull @Initialized int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw e;
    }
}

