/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io;

import java.util.Objects;
import randoop.org.apache.commons.io.FilenameUtils;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public enum IOCase {
    SENSITIVE("Sensitive", true),
    INSENSITIVE("Insensitive", false),
    SYSTEM("System", !FilenameUtils.isSystemWindows());

    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -6343169151696340687L;
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final transient @UnknownKeyFor @NonNull @Initialized boolean sensitive;

    public static @UnknownKeyFor @NonNull @Initialized IOCase forName(@UnknownKeyFor @NonNull @Initialized String name) {
        for (IOCase ioCase : IOCase.values()) {
            if (!ioCase.getName().equals(name)) continue;
            return ioCase;
        }
        throw new IllegalArgumentException("Invalid IOCase name: " + name);
    }

    private IOCase(String name, boolean sensitive) {
        this.name = name;
        this.sensitive = sensitive;
    }

    private @UnknownKeyFor @NonNull @Initialized Object readResolve() {
        return IOCase.forName(this.name);
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCaseSensitive() {
        return this.sensitive;
    }

    public @UnknownKeyFor @NonNull @Initialized int checkCompareTo(@UnknownKeyFor @NonNull @Initialized String str1, @UnknownKeyFor @NonNull @Initialized String str2) {
        Objects.requireNonNull(str1, "str1");
        Objects.requireNonNull(str2, "str2");
        return this.sensitive ? str1.compareTo(str2) : str1.compareToIgnoreCase(str2);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean checkEquals(@UnknownKeyFor @NonNull @Initialized String str1, @UnknownKeyFor @NonNull @Initialized String str2) {
        Objects.requireNonNull(str1, "str1");
        Objects.requireNonNull(str2, "str2");
        return this.sensitive ? str1.equals(str2) : str1.equalsIgnoreCase(str2);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean checkStartsWith(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized String start) {
        return str.regionMatches(!this.sensitive, 0, start, 0, start.length());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean checkEndsWith(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized String end) {
        int endLen = end.length();
        return str.regionMatches(!this.sensitive, str.length() - endLen, end, 0, endLen);
    }

    public @UnknownKeyFor @NonNull @Initialized int checkIndexOf(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int strStartIndex, @UnknownKeyFor @NonNull @Initialized String search) {
        int endIndex = str.length() - search.length();
        if (endIndex >= strStartIndex) {
            for (int i = strStartIndex; i <= endIndex; ++i) {
                if (!this.checkRegionMatches(str, i, search)) continue;
                return i;
            }
        }
        return -1;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean checkRegionMatches(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int strStartIndex, @UnknownKeyFor @NonNull @Initialized String search) {
        return str.regionMatches(!this.sensitive, strStartIndex, search, 0, search.length());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.name;
    }
}

