/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import randoop.org.apache.commons.io.IOCase;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.PolyNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.common.value.qual.ArrayLen;

public class FilenameUtils {
    private static final @UnknownKeyFor @NonNull @Initialized String @ArrayLen(value={0}) @UnknownKeyFor @NonNull @Initialized [] EMPTY_STRING_ARRAY = new String[0];
    private static final @UnknownKeyFor @NonNull @Initialized String EMPTY_STRING = "";
    private static final @UnknownKeyFor @NonNull @Initialized int NOT_FOUND = -1;
    public static final @UnknownKeyFor @NonNull @Initialized char EXTENSION_SEPARATOR = '.';
    public static final @UnknownKeyFor @NonNull @Initialized String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final @UnknownKeyFor @NonNull @Initialized char UNIX_SEPARATOR = '/';
    private static final @UnknownKeyFor @NonNull @Initialized char WINDOWS_SEPARATOR = '\\';
    private static final @UnknownKeyFor @NonNull @Initialized char SYSTEM_SEPARATOR = File.separatorChar;
    private static final @UnknownKeyFor @NonNull @Initialized char OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern IPV4_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final @UnknownKeyFor @NonNull @Initialized int IPV4_MAX_OCTET_VALUE = 255;
    private static final @UnknownKeyFor @NonNull @Initialized int IPV6_MAX_HEX_GROUPS = 8;
    private static final @UnknownKeyFor @NonNull @Initialized int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_UNSIGNED_SHORT = 65535;
    private static final @UnknownKeyFor @NonNull @Initialized int BASE_16 = 16;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern REG_NAME_PART_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9-]*$");

    static @UnknownKeyFor @NonNull @Initialized boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isSeparator(@UnknownKeyFor @NonNull @Initialized char ch) {
        return ch == '/' || ch == '\\';
    }

    public static @Nullable @UnknownKeyFor @Initialized String normalize(@Nullable @UnknownKeyFor @Initialized String fileName) {
        return FilenameUtils.doNormalize(fileName, SYSTEM_SEPARATOR, true);
    }

    public static @Nullable @UnknownKeyFor @Initialized String normalize(@Nullable @UnknownKeyFor @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized boolean unixSeparator) {
        char separator = unixSeparator ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(fileName, separator, true);
    }

    public static @Nullable @UnknownKeyFor @Initialized String normalizeNoEndSeparator(@Nullable @UnknownKeyFor @Initialized String fileName) {
        return FilenameUtils.doNormalize(fileName, SYSTEM_SEPARATOR, false);
    }

    public static @Nullable @UnknownKeyFor @Initialized String normalizeNoEndSeparator(@Nullable @UnknownKeyFor @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized boolean unixSeparator) {
        char separator = unixSeparator ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(fileName, separator, false);
    }

    private static @Nullable @UnknownKeyFor @Initialized String doNormalize(@Nullable @UnknownKeyFor @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized char separator, @UnknownKeyFor @NonNull @Initialized boolean keepSeparator) {
        int i;
        if (fileName == null) {
            return null;
        }
        FilenameUtils.failIfNullBytePresent(fileName);
        int size = fileName.length();
        if (size == 0) {
            return fileName;
        }
        int prefix = FilenameUtils.getPrefixLength(fileName);
        if (prefix < 0) {
            return null;
        }
        char[] array = new char[size + 2];
        fileName.getChars(0, fileName.length(), array, 0);
        char otherSeparator = separator == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != otherSeparator) continue;
            array[i2] = separator;
        }
        boolean lastIsDirectory = true;
        if (array[size - 1] != separator) {
            array[size++] = separator;
            lastIsDirectory = false;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != separator) continue;
            System.arraycopy(array, i, array, i - 1, size - i);
            --size;
            --i;
        }
        for (i = prefix + 1; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || i != prefix + 1 && array[i - 2] != separator) continue;
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i + 1, array, i - 1, size - i);
            size -= 2;
            --i;
        }
        block3: for (i = prefix + 2; i < size; ++i) {
            if (array[i] != separator || array[i - 1] != '.' || array[i - 2] != '.' || i != prefix + 2 && array[i - 3] != separator) continue;
            if (i == prefix + 2) {
                return null;
            }
            if (i == size - 1) {
                lastIsDirectory = true;
            }
            for (int j = i - 4; j >= prefix; --j) {
                if (array[j] != separator) continue;
                System.arraycopy(array, i + 1, array, j + 1, size - i);
                size -= i - j;
                i = j + 1;
                continue block3;
            }
            System.arraycopy(array, i + 1, array, prefix, size - i);
            size -= i + 1 - prefix;
            i = prefix + 1;
        }
        if (size <= 0) {
            return EMPTY_STRING;
        }
        if (size <= prefix) {
            return new String(array, 0, size);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size);
        }
        return new String(array, 0, size - 1);
    }

    public static @Nullable @UnknownKeyFor @Initialized String concat(@UnknownKeyFor @NonNull @Initialized String basePath, @UnknownKeyFor @NonNull @Initialized String fullFileNameToAdd) {
        int prefix = FilenameUtils.getPrefixLength(fullFileNameToAdd);
        if (prefix < 0) {
            return null;
        }
        if (prefix > 0) {
            return FilenameUtils.normalize(fullFileNameToAdd);
        }
        if (basePath == null) {
            return null;
        }
        int len = basePath.length();
        if (len == 0) {
            return FilenameUtils.normalize(fullFileNameToAdd);
        }
        char ch = basePath.charAt(len - 1);
        if (FilenameUtils.isSeparator(ch)) {
            return FilenameUtils.normalize(basePath + fullFileNameToAdd);
        }
        return FilenameUtils.normalize(basePath + '/' + fullFileNameToAdd);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean directoryContains(@UnknownKeyFor @NonNull @Initialized String canonicalParent, @UnknownKeyFor @NonNull @Initialized String canonicalChild) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (canonicalParent == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (canonicalChild == null) {
            return false;
        }
        if (IOCase.SYSTEM.checkEquals(canonicalParent, canonicalChild)) {
            return false;
        }
        return IOCase.SYSTEM.checkStartsWith(canonicalChild, canonicalParent);
    }

    public static @UnknownKeyFor @NonNull @Initialized String separatorsToUnix(@UnknownKeyFor @NonNull @Initialized String path) {
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static @UnknownKeyFor @NonNull @Initialized String separatorsToWindows(@UnknownKeyFor @NonNull @Initialized String path) {
        if (path == null || path.indexOf(47) == -1) {
            return path;
        }
        return path.replace('/', '\\');
    }

    public static @Nullable @UnknownKeyFor @Initialized String separatorsToSystem(@Nullable @UnknownKeyFor @Initialized String path) {
        if (path == null) {
            return null;
        }
        return FilenameUtils.isSystemWindows() ? FilenameUtils.separatorsToWindows(path) : FilenameUtils.separatorsToUnix(path);
    }

    public static @UnknownKeyFor @NonNull @Initialized int getPrefixLength(@Nullable @UnknownKeyFor @Initialized String fileName) {
        if (fileName == null) {
            return -1;
        }
        int len = fileName.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = fileName.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return FilenameUtils.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = fileName.indexOf(47, 1);
            int posWin = fileName.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = fileName.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !FilenameUtils.isSeparator(fileName.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            if (ch0 == '/') {
                return 1;
            }
            return -1;
        }
        if (FilenameUtils.isSeparator(ch0) && FilenameUtils.isSeparator(ch1)) {
            int posUnix = fileName.indexOf(47, 2);
            int posWin = fileName.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            int pos = Math.min(posUnix, posWin) + 1;
            String hostnamePart = fileName.substring(2, pos - 1);
            return FilenameUtils.isValidHostName(hostnamePart) ? pos : -1;
        }
        return FilenameUtils.isSeparator(ch0) ? 1 : 0;
    }

    public static @UnknownKeyFor @NonNull @Initialized int indexOfLastSeparator(@Nullable @UnknownKeyFor @Initialized String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static @UnknownKeyFor @NonNull @Initialized int indexOfExtension(@Nullable @UnknownKeyFor @Initialized String fileName) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
        int offset;
        if (fileName == null) {
            return -1;
        }
        if (FilenameUtils.isSystemWindows() && (offset = fileName.indexOf(58, FilenameUtils.getAdsCriticalOffset(fileName))) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        int extensionPos = fileName.lastIndexOf(46);
        int lastSeparator = FilenameUtils.indexOfLastSeparator(fileName);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static @Nullable @UnknownKeyFor @Initialized String getPrefix(@Nullable @UnknownKeyFor @Initialized String fileName) {
        if (fileName == null) {
            return null;
        }
        int len = FilenameUtils.getPrefixLength(fileName);
        if (len < 0) {
            return null;
        }
        if (len > fileName.length()) {
            FilenameUtils.failIfNullBytePresent(fileName + '/');
            return fileName + '/';
        }
        String path = fileName.substring(0, len);
        FilenameUtils.failIfNullBytePresent(path);
        return path;
    }

    public static @Nullable @UnknownKeyFor @Initialized String getPath(@Nullable @UnknownKeyFor @Initialized String fileName) {
        return FilenameUtils.doGetPath(fileName, 1);
    }

    public static @Nullable @UnknownKeyFor @Initialized String getPathNoEndSeparator(@Nullable @UnknownKeyFor @Initialized String fileName) {
        return FilenameUtils.doGetPath(fileName, 0);
    }

    private static @Nullable @UnknownKeyFor @Initialized String doGetPath(@Nullable @UnknownKeyFor @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized int separatorAdd) {
        if (fileName == null) {
            return null;
        }
        int prefix = FilenameUtils.getPrefixLength(fileName);
        if (prefix < 0) {
            return null;
        }
        int index = FilenameUtils.indexOfLastSeparator(fileName);
        int endIndex = index + separatorAdd;
        if (prefix >= fileName.length() || index < 0 || prefix >= endIndex) {
            return EMPTY_STRING;
        }
        String path = fileName.substring(prefix, endIndex);
        FilenameUtils.failIfNullBytePresent(path);
        return path;
    }

    public static @Nullable @UnknownKeyFor @Initialized String getFullPath(@Nullable @UnknownKeyFor @Initialized String fileName) {
        return FilenameUtils.doGetFullPath(fileName, true);
    }

    public static @Nullable @UnknownKeyFor @Initialized String getFullPathNoEndSeparator(@Nullable @UnknownKeyFor @Initialized String fileName) {
        return FilenameUtils.doGetFullPath(fileName, false);
    }

    private static @Nullable @UnknownKeyFor @Initialized String doGetFullPath(@Nullable @UnknownKeyFor @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized boolean includeSeparator) {
        if (fileName == null) {
            return null;
        }
        int prefix = FilenameUtils.getPrefixLength(fileName);
        if (prefix < 0) {
            return null;
        }
        if (prefix >= fileName.length()) {
            if (includeSeparator) {
                return FilenameUtils.getPrefix(fileName);
            }
            return fileName;
        }
        int index = FilenameUtils.indexOfLastSeparator(fileName);
        if (index < 0) {
            return fileName.substring(0, prefix);
        }
        int end = index + (includeSeparator ? 1 : 0);
        if (end == 0) {
            ++end;
        }
        return fileName.substring(0, end);
    }

    public static @PolyNull @UnknownKeyFor @Initialized String getName(@PolyNull @UnknownKeyFor @Initialized String fileName) {
        if (fileName == null) {
            return null;
        }
        FilenameUtils.failIfNullBytePresent(fileName);
        int index = FilenameUtils.indexOfLastSeparator(fileName);
        return fileName.substring(index + 1);
    }

    private static void failIfNullBytePresent(@UnknownKeyFor @NonNull @Initialized String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            if (path.charAt(i) != '\u0000') continue;
            throw new IllegalArgumentException("Null byte present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
    }

    public static @Nullable @UnknownKeyFor @Initialized String getBaseName(@Nullable @UnknownKeyFor @Initialized String fileName) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(fileName));
    }

    public static @PolyNull @UnknownKeyFor @Initialized String getExtension(@PolyNull @UnknownKeyFor @Initialized String fileName) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
        if (fileName == null) {
            return null;
        }
        int index = FilenameUtils.indexOfExtension(fileName);
        if (index == -1) {
            return EMPTY_STRING;
        }
        return fileName.substring(index + 1);
    }

    private static @UnknownKeyFor @NonNull @Initialized int getAdsCriticalOffset(@UnknownKeyFor @NonNull @Initialized String fileName) {
        int offset1 = fileName.lastIndexOf(SYSTEM_SEPARATOR);
        int offset2 = fileName.lastIndexOf(OTHER_SEPARATOR);
        if (offset1 == -1) {
            if (offset2 == -1) {
                return 0;
            }
            return offset2 + 1;
        }
        if (offset2 == -1) {
            return offset1 + 1;
        }
        return Math.max(offset1, offset2) + 1;
    }

    public static @PolyNull @UnknownKeyFor @Initialized String removeExtension(@PolyNull @UnknownKeyFor @Initialized String fileName) {
        if (fileName == null) {
            return null;
        }
        FilenameUtils.failIfNullBytePresent(fileName);
        int index = FilenameUtils.indexOfExtension(fileName);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized String fileName1, @Nullable @UnknownKeyFor @Initialized String fileName2) {
        return FilenameUtils.equals(fileName1, fileName2, false, IOCase.SENSITIVE);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean equalsOnSystem(@Nullable @UnknownKeyFor @Initialized String fileName1, @Nullable @UnknownKeyFor @Initialized String fileName2) {
        return FilenameUtils.equals(fileName1, fileName2, false, IOCase.SYSTEM);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean equalsNormalized(@Nullable @UnknownKeyFor @Initialized String fileName1, @Nullable @UnknownKeyFor @Initialized String fileName2) {
        return FilenameUtils.equals(fileName1, fileName2, true, IOCase.SENSITIVE);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean equalsNormalizedOnSystem(@Nullable @UnknownKeyFor @Initialized String fileName1, @Nullable @UnknownKeyFor @Initialized String fileName2) {
        return FilenameUtils.equals(fileName1, fileName2, true, IOCase.SYSTEM);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized String fileName1, @Nullable @UnknownKeyFor @Initialized String fileName2, @UnknownKeyFor @NonNull @Initialized boolean normalized, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        if (fileName1 == null || fileName2 == null) {
            return fileName1 == null && fileName2 == null;
        }
        if (normalized) {
            fileName1 = FilenameUtils.normalize(fileName1);
            fileName2 = FilenameUtils.normalize(fileName2);
            Objects.requireNonNull(fileName1, "Error normalizing one or both of the file names");
            Objects.requireNonNull(fileName2, "Error normalizing one or both of the file names");
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        return caseSensitivity.checkEquals(fileName1, fileName2);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isExtension(@Nullable @UnknownKeyFor @Initialized String fileName, @Nullable @UnknownKeyFor @Initialized String extension) {
        if (fileName == null) {
            return false;
        }
        FilenameUtils.failIfNullBytePresent(fileName);
        if (extension == null || extension.isEmpty()) {
            return FilenameUtils.indexOfExtension(fileName) == -1;
        }
        String fileExt = FilenameUtils.getExtension(fileName);
        return fileExt.equals(extension);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isExtension(@Nullable @UnknownKeyFor @Initialized String fileName, String ... extensions) {
        if (fileName == null) {
            return false;
        }
        FilenameUtils.failIfNullBytePresent(fileName);
        if (extensions == null || extensions.length == 0) {
            return FilenameUtils.indexOfExtension(fileName) == -1;
        }
        String fileExt = FilenameUtils.getExtension(fileName);
        for (String extension : extensions) {
            if (!fileExt.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isExtension(@Nullable @UnknownKeyFor @Initialized String fileName, @Nullable @UnknownKeyFor @Initialized Collection<@Nullable @UnknownKeyFor @Initialized String> extensions) {
        if (fileName == null) {
            return false;
        }
        FilenameUtils.failIfNullBytePresent(fileName);
        if (extensions == null || extensions.isEmpty()) {
            return FilenameUtils.indexOfExtension(fileName) == -1;
        }
        String fileExt = FilenameUtils.getExtension(fileName);
        for (String extension : extensions) {
            if (!fileExt.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean wildcardMatch(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized String wildcardMatcher) {
        return FilenameUtils.wildcardMatch(fileName, wildcardMatcher, IOCase.SENSITIVE);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean wildcardMatchOnSystem(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized String wildcardMatcher) {
        return FilenameUtils.wildcardMatch(fileName, wildcardMatcher, IOCase.SYSTEM);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean wildcardMatch(@UnknownKeyFor @NonNull @Initialized String fileName, @UnknownKeyFor @NonNull @Initialized String wildcardMatcher, @Nullable @UnknownKeyFor @Initialized IOCase caseSensitivity) {
        if (fileName == null && wildcardMatcher == null) {
            return true;
        }
        if (fileName == null || wildcardMatcher == null) {
            return false;
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        String[] wcs = FilenameUtils.splitOnTokens(wildcardMatcher);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        ArrayDeque<int[]> backtrack = new ArrayDeque<int[]>(wcs.length);
        do {
            if (!backtrack.isEmpty()) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > fileName.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = fileName.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = caseSensitivity.checkIndexOf(fileName, textIdx, wcs[wcsIdx])) == -1) break;
                        int repeat = caseSensitivity.checkIndexOf(fileName, textIdx + 1, wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!caseSensitivity.checkRegionMatches(fileName, textIdx, wcs[wcsIdx])) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != fileName.length()) continue;
            return true;
        } while (!backtrack.isEmpty());
        return false;
    }

    static @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] splitOnTokens(@UnknownKeyFor @NonNull @Initialized String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        char prevChar = '\u0000';
        for (char ch : array) {
            if (ch == '?' || ch == '*') {
                if (buffer.length() != 0) {
                    list.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (ch == '?') {
                    list.add("?");
                } else if (prevChar != '*') {
                    list.add("*");
                }
            } else {
                buffer.append(ch);
            }
            prevChar = ch;
        }
        if (buffer.length() != 0) {
            list.add(buffer.toString());
        }
        return list.toArray(EMPTY_STRING_ARRAY);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isValidHostName(@UnknownKeyFor @NonNull @Initialized String name) {
        return FilenameUtils.isIPv6Address(name) || FilenameUtils.isRFC3986HostName(name);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isIPv4Address(@UnknownKeyFor @NonNull @Initialized String name) {
        Matcher m3 = IPV4_PATTERN.matcher(name);
        if (!m3.matches() || m3.groupCount() != 4) {
            return false;
        }
        for (int i = 1; i <= 4; ++i) {
            String ipSegment = m3.group(i);
            int iIpSegment = Integer.parseInt(ipSegment);
            if (iIpSegment > 255) {
                return false;
            }
            if (ipSegment.length() <= 1 || !ipSegment.startsWith("0")) continue;
            return false;
        }
        return true;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isIPv6Address(@UnknownKeyFor @NonNull @Initialized String inet6Address) {
        boolean containsCompressedZeroes = inet6Address.contains("::");
        if (containsCompressedZeroes && inet6Address.indexOf("::") != inet6Address.lastIndexOf("::")) {
            return false;
        }
        if (inet6Address.startsWith(":") && !inet6Address.startsWith("::") || inet6Address.endsWith(":") && !inet6Address.endsWith("::")) {
            return false;
        }
        String[] octets = inet6Address.split(":");
        if (containsCompressedZeroes) {
            ArrayList<String> octetList = new ArrayList<String>(Arrays.asList(octets));
            if (inet6Address.endsWith("::")) {
                octetList.add(EMPTY_STRING);
            } else if (inet6Address.startsWith("::") && !octetList.isEmpty()) {
                octetList.remove(0);
            }
            octets = octetList.toArray(EMPTY_STRING_ARRAY);
        }
        if (octets.length > 8) {
            return false;
        }
        int validOctets = 0;
        int emptyOctets = 0;
        for (int index = 0; index < octets.length; ++index) {
            String octet = octets[index];
            if (octet.length() == 0) {
                if (++emptyOctets > 1) {
                    return false;
                }
            } else {
                emptyOctets = 0;
                if (index == octets.length - 1 && octet.contains(".")) {
                    if (!FilenameUtils.isIPv4Address(octet)) {
                        return false;
                    }
                    validOctets += 2;
                    continue;
                }
                if (octet.length() > 4) {
                    return false;
                }
                int octetInt = 0;
                try {
                    octetInt = Integer.parseInt(octet, 16);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (octetInt < 0 || octetInt > 65535) {
                    return false;
                }
            }
            ++validOctets;
        }
        return validOctets <= 8 && (validOctets >= 8 || containsCompressedZeroes);
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isRFC3986HostName(@UnknownKeyFor @NonNull @Initialized String name) {
        String[] parts = name.split("\\.", -1);
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].length() == 0) {
                return i == parts.length - 1;
            }
            if (REG_NAME_PART_PATTERN.matcher(parts[i]).matches()) continue;
            return false;
        }
        return true;
    }
}

