/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.commons.io;

import java.io.File;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import randoop.org.apache.commons.io.FileDeleteStrategy;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import randoop.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FileCleaningTracker {
    @UnknownKeyFor @NonNull @Initialized ReferenceQueue<@UnknownKeyFor @NonNull @Initialized Object> q = new ReferenceQueue();
    final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Tracker> trackers = Collections.synchronizedSet(new HashSet());
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> deleteFailures = Collections.synchronizedList(new ArrayList());
    volatile @UnknownKeyFor @NonNull @Initialized boolean exitWhenFinished = false;
    @MonotonicNonNull @UnknownKeyFor @Initialized Thread reaper;

    public void track(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized Object marker) {
        this.track(file, marker, null);
    }

    public void track(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized Object marker, @Nullable @UnknownKeyFor @Initialized FileDeleteStrategy deleteStrategy) {
        Objects.requireNonNull(file, "file");
        this.addTracker(file.getPath(), marker, deleteStrategy);
    }

    public void track(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized Object marker) {
        this.track(path, marker, null);
    }

    public void track(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized Object marker, @Nullable @UnknownKeyFor @Initialized FileDeleteStrategy deleteStrategy) {
        Objects.requireNonNull(path, "path");
        this.addTracker(path, marker, deleteStrategy);
    }

    @EnsuresNonNull(value={"reaper"})
    private synchronized void addTracker(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized Object marker, @Nullable @UnknownKeyFor @Initialized FileDeleteStrategy deleteStrategy) {
        if (this.exitWhenFinished) {
            throw new IllegalStateException("No new trackers can be added once exitWhenFinished() is called");
        }
        if (this.reaper == null) {
            this.reaper = new Reaper();
            this.reaper.start();
        }
        this.trackers.add(new Tracker(path, deleteStrategy, marker, this.q));
    }

    public @UnknownKeyFor @NonNull @Initialized int getTrackCount() {
        return this.trackers.size();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDeleteFailures() {
        return this.deleteFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exitWhenFinished() {
        this.exitWhenFinished = true;
        if (this.reaper != null) {
            Thread thread = this.reaper;
            synchronized (thread) {
                this.reaper.interrupt();
            }
        }
    }

    private static final class Tracker
    extends PhantomReference<Object> {
        private final @UnknownKeyFor @NonNull @Initialized String path;
        private final @UnknownKeyFor @NonNull @Initialized FileDeleteStrategy deleteStrategy;

        Tracker(@UnknownKeyFor @NonNull @Initialized String path, @Nullable @UnknownKeyFor @Initialized FileDeleteStrategy deleteStrategy, @UnknownKeyFor @NonNull @Initialized Object marker, @UnknownKeyFor @NonNull @Initialized ReferenceQueue<@UnknownKeyFor @Nullable @Initialized ? super @UnknownKeyFor @NonNull @Initialized Object> queue) {
            super(marker, queue);
            this.path = path;
            this.deleteStrategy = deleteStrategy == null ? FileDeleteStrategy.NORMAL : deleteStrategy;
        }

        public @UnknownKeyFor @NonNull @Initialized String getPath() {
            return this.path;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean delete() {
            return this.deleteStrategy.deleteQuietly(new File(this.path));
        }
    }

    private final class Reaper
    extends Thread {
        Reaper() {
            super("File Reaper");
            this.setPriority(10);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!FileCleaningTracker.this.exitWhenFinished || FileCleaningTracker.this.trackers.size() > 0) {
                try {
                    Tracker tracker = (Tracker)FileCleaningTracker.this.q.remove();
                    FileCleaningTracker.this.trackers.remove(tracker);
                    if (!tracker.delete()) {
                        FileCleaningTracker.this.deleteFailures.add(tracker.getPath());
                    }
                    tracker.clear();
                }
                catch (InterruptedException e) {}
            }
        }
    }
}

