/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.verifier.statics;

import randoop.org.apache.bcel.Repository;
import randoop.org.apache.bcel.classfile.ClassFormatException;
import randoop.org.apache.bcel.classfile.JavaClass;
import randoop.org.apache.bcel.verifier.PassVerifier;
import randoop.org.apache.bcel.verifier.VerificationResult;
import randoop.org.apache.bcel.verifier.Verifier;
import randoop.org.apache.bcel.verifier.exc.LoadingException;
import randoop.org.apache.bcel.verifier.exc.Utility;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public final class Pass1Verifier
extends PassVerifier {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass jc;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier myOwner;

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass getJavaClass() {
        if (this.jc == null) {
            try {
                this.jc = Repository.lookupClass(this.myOwner.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.jc;
    }

    public Pass1Verifier(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier owner) {
        this.myOwner = owner;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerificationResult do_verify() {
        JavaClass jc;
        try {
            jc = this.getJavaClass();
            if (jc != null && !this.myOwner.getClassName().equals(jc.getClassName())) {
                throw new LoadingException("Wrong name: the internal name of the .class file '" + jc.getClassName() + "' does not match the file's name '" + this.myOwner.getClassName() + "'.");
            }
        }
        catch (LoadingException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (ClassFormatException e) {
            return new VerificationResult(2, e.getMessage());
        }
        catch (RuntimeException e) {
            return new VerificationResult(2, "Parsing via BCEL did not succeed. " + e.getClass().getName() + " occured:\n" + Utility.getStackTrace(e));
        }
        if (jc != null) {
            return VerificationResult.VR_OK;
        }
        return new VerificationResult(2, "Repository.lookup() failed. FILE NOT FOUND?");
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getMessages() {
        return super.getMessages();
    }
}

