/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.verifier;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import randoop.org.apache.bcel.verifier.Verifier;
import randoop.org.apache.bcel.verifier.VerifierFactoryObserver;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class VerifierFactory {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier> hashMap = new HashMap<String, Verifier>();
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerifierFactoryObserver> observers = new Vector<VerifierFactoryObserver>();

    private VerifierFactory() {
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier getVerifier(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fullyQualifiedClassName) {
        Verifier v = hashMap.get(fullyQualifiedClassName);
        if (v == null) {
            v = new Verifier(fullyQualifiedClassName);
            hashMap.put(fullyQualifiedClassName, v);
            VerifierFactory.notify(fullyQualifiedClassName);
        }
        return v;
    }

    private static void notify(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String fullyQualifiedClassName) {
        for (VerifierFactoryObserver vfo : observers) {
            vfo.update(fullyQualifiedClassName);
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Verifier @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getVerifiers() {
        Verifier[] vs = new Verifier[hashMap.values().size()];
        return hashMap.values().toArray(vs);
    }

    public static void attach(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerifierFactoryObserver o) {
        observers.add(o);
    }

    public static void detach(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown VerifierFactoryObserver o) {
        observers.remove(o);
    }
}

