/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import randoop.org.apache.bcel.classfile.JavaClass;
import randoop.org.apache.bcel.util.AbstractClassPathRepository;
import randoop.org.apache.bcel.util.ClassPath;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class MemorySensitiveClassPathRepository
extends AbstractClassPathRepository {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown SoftReference<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass>> _loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    public MemorySensitiveClassPathRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassPath path) {
        super(path);
    }

    @Override
    public void storeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        this._loadedClasses.put(clazz.getClassName(), new SoftReference<JavaClass>(clazz));
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown JavaClass clazz) {
        this._loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown JavaClass findClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String className) {
        SoftReference<JavaClass> ref = this._loadedClasses.get(className);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

