/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.generic;

import randoop.org.apache.bcel.generic.ALOAD;
import randoop.org.apache.bcel.generic.ANEWARRAY;
import randoop.org.apache.bcel.generic.ASTORE;
import randoop.org.apache.bcel.generic.ArithmeticInstruction;
import randoop.org.apache.bcel.generic.ArrayInstruction;
import randoop.org.apache.bcel.generic.ArrayType;
import randoop.org.apache.bcel.generic.BasicType;
import randoop.org.apache.bcel.generic.BranchInstruction;
import randoop.org.apache.bcel.generic.CHECKCAST;
import randoop.org.apache.bcel.generic.ClassGen;
import randoop.org.apache.bcel.generic.ClassGenException;
import randoop.org.apache.bcel.generic.ConstantPoolGen;
import randoop.org.apache.bcel.generic.DLOAD;
import randoop.org.apache.bcel.generic.DSTORE;
import randoop.org.apache.bcel.generic.FLOAD;
import randoop.org.apache.bcel.generic.FSTORE;
import randoop.org.apache.bcel.generic.FieldInstruction;
import randoop.org.apache.bcel.generic.GETFIELD;
import randoop.org.apache.bcel.generic.GETSTATIC;
import randoop.org.apache.bcel.generic.GOTO;
import randoop.org.apache.bcel.generic.GOTO_W;
import randoop.org.apache.bcel.generic.IFEQ;
import randoop.org.apache.bcel.generic.IFGE;
import randoop.org.apache.bcel.generic.IFGT;
import randoop.org.apache.bcel.generic.IFLE;
import randoop.org.apache.bcel.generic.IFLT;
import randoop.org.apache.bcel.generic.IFNE;
import randoop.org.apache.bcel.generic.IFNONNULL;
import randoop.org.apache.bcel.generic.IFNULL;
import randoop.org.apache.bcel.generic.IF_ACMPEQ;
import randoop.org.apache.bcel.generic.IF_ACMPNE;
import randoop.org.apache.bcel.generic.IF_ICMPEQ;
import randoop.org.apache.bcel.generic.IF_ICMPGE;
import randoop.org.apache.bcel.generic.IF_ICMPGT;
import randoop.org.apache.bcel.generic.IF_ICMPLE;
import randoop.org.apache.bcel.generic.IF_ICMPLT;
import randoop.org.apache.bcel.generic.IF_ICMPNE;
import randoop.org.apache.bcel.generic.ILOAD;
import randoop.org.apache.bcel.generic.INSTANCEOF;
import randoop.org.apache.bcel.generic.INVOKEDYNAMIC;
import randoop.org.apache.bcel.generic.INVOKEINTERFACE;
import randoop.org.apache.bcel.generic.INVOKESPECIAL;
import randoop.org.apache.bcel.generic.INVOKESTATIC;
import randoop.org.apache.bcel.generic.INVOKEVIRTUAL;
import randoop.org.apache.bcel.generic.ISTORE;
import randoop.org.apache.bcel.generic.Instruction;
import randoop.org.apache.bcel.generic.InstructionConst;
import randoop.org.apache.bcel.generic.InstructionConstants;
import randoop.org.apache.bcel.generic.InstructionHandle;
import randoop.org.apache.bcel.generic.InstructionList;
import randoop.org.apache.bcel.generic.InvokeInstruction;
import randoop.org.apache.bcel.generic.JSR;
import randoop.org.apache.bcel.generic.JSR_W;
import randoop.org.apache.bcel.generic.LLOAD;
import randoop.org.apache.bcel.generic.LSTORE;
import randoop.org.apache.bcel.generic.LocalVariableInstruction;
import randoop.org.apache.bcel.generic.MULTIANEWARRAY;
import randoop.org.apache.bcel.generic.NEW;
import randoop.org.apache.bcel.generic.NEWARRAY;
import randoop.org.apache.bcel.generic.ObjectType;
import randoop.org.apache.bcel.generic.PUSH;
import randoop.org.apache.bcel.generic.PUTFIELD;
import randoop.org.apache.bcel.generic.PUTSTATIC;
import randoop.org.apache.bcel.generic.ReferenceType;
import randoop.org.apache.bcel.generic.ReturnInstruction;
import randoop.org.apache.bcel.generic.StackInstruction;
import randoop.org.apache.bcel.generic.Type;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class InstructionFactory
implements InstructionConstants {
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] short_names = new String[]{"C", "F", "D", "B", "S", "I", "L"};
    @Deprecated
    protected @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassGen cg;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp;
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodObject @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] append_mos = new MethodObject[]{new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.OBJECT}), null, null, new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.BOOLEAN}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.CHAR}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.FLOAT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.DOUBLE}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.LONG})};

    public InstructionFactory(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassGen cg, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        this.cg = cg;
        this.cp = cp;
    }

    public InstructionFactory(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassGen cg) {
        this(cg, cg.getConstantPool());
    }

    public InstructionFactory(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cp) {
        this(null, cp);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InvokeInstruction createInvoke(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type ret_type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_types, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short kind) {
        return this.createInvoke(class_name, name, ret_type, arg_types, kind, kind == 185);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InvokeInstruction createInvoke(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type ret_type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_types, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short kind, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean use_interface) {
        int nargs = 0;
        String signature = Type.getMethodSignature(ret_type, arg_types);
        for (Type arg_type : arg_types) {
            nargs += arg_type.getSize();
        }
        int index = use_interface ? this.cp.addInterfaceMethodref(class_name, name, signature) : this.cp.addMethodref(class_name, name, signature);
        switch (kind) {
            case 183: {
                return new INVOKESPECIAL(index);
            }
            case 182: {
                return new INVOKEVIRTUAL(index);
            }
            case 184: {
                return new INVOKESTATIC(index);
            }
            case 185: {
                return new INVOKEINTERFACE(index, nargs + 1);
            }
            case 186: {
                return new INVOKEDYNAMIC(index);
            }
        }
        throw new RuntimeException("Oops: Unknown invoke kind: " + kind);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionList createPrintln(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s2) {
        InstructionList il = new InstructionList();
        int out = this.cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
        int println = this.cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
        il.append(new GETSTATIC(out));
        il.append(new PUSH(this.cp, s2));
        il.append(new INVOKEVIRTUAL(println));
        return il;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction createConstant(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Object value) {
        PUSH push;
        if (value instanceof Number) {
            push = new PUSH(this.cp, (Number)value);
        } else if (value instanceof String) {
            push = new PUSH(this.cp, (String)value);
        } else if (value instanceof Boolean) {
            push = new PUSH(this.cp, (Boolean)value);
        } else if (value instanceof Character) {
            push = new PUSH(this.cp, (Character)value);
        } else {
            throw new ClassGenException("Illegal type: " + value.getClass());
        }
        return push.getInstruction();
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InvokeInstruction createInvoke(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodObject m3, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short kind) {
        return this.createInvoke(m3.class_name, m3.name, m3.result_type, m3.arg_types, kind);
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        return type instanceof ObjectType && ((ObjectType)type).getClassName().equals("java.lang.String");
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction createAppend(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        byte t = type.getType();
        if (InstructionFactory.isString(type)) {
            return this.createInvoke(append_mos[0], (short)182);
        }
        switch (t) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createInvoke(append_mos[t], (short)182);
            }
            case 13: 
            case 14: {
                return this.createInvoke(append_mos[1], (short)182);
            }
        }
        throw new RuntimeException("Oops: No append for this type? " + type);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown FieldInstruction createFieldAccess(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short kind) {
        String signature = type.getSignature();
        int index = this.cp.addFieldref(class_name, name, signature);
        switch (kind) {
            case 180: {
                return new GETFIELD(index);
            }
            case 181: {
                return new PUTFIELD(index);
            }
            case 178: {
                return new GETSTATIC(index);
            }
            case 179: {
                return new PUTSTATIC(index);
            }
        }
        throw new RuntimeException("Oops: Unknown getfield kind:" + kind);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction createThis() {
        return new ALOAD(0);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReturnInstruction createReturn(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConst.ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConst.IRETURN;
            }
            case 6: {
                return InstructionConst.FRETURN;
            }
            case 7: {
                return InstructionConst.DRETURN;
            }
            case 11: {
                return InstructionConst.LRETURN;
            }
            case 12: {
                return InstructionConst.RETURN;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArithmeticInstruction createBinaryIntOp(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char first, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String op) {
        switch (first) {
            case '-': {
                return InstructionConst.ISUB;
            }
            case '+': {
                return InstructionConst.IADD;
            }
            case '%': {
                return InstructionConst.IREM;
            }
            case '*': {
                return InstructionConst.IMUL;
            }
            case '/': {
                return InstructionConst.IDIV;
            }
            case '&': {
                return InstructionConst.IAND;
            }
            case '|': {
                return InstructionConst.IOR;
            }
            case '^': {
                return InstructionConst.IXOR;
            }
            case '<': {
                return InstructionConst.ISHL;
            }
            case '>': {
                return op.equals(">>>") ? InstructionConst.IUSHR : InstructionConst.ISHR;
            }
        }
        throw new RuntimeException("Invalid operand " + op);
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArithmeticInstruction createBinaryLongOp(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char first, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String op) {
        switch (first) {
            case '-': {
                return InstructionConst.LSUB;
            }
            case '+': {
                return InstructionConst.LADD;
            }
            case '%': {
                return InstructionConst.LREM;
            }
            case '*': {
                return InstructionConst.LMUL;
            }
            case '/': {
                return InstructionConst.LDIV;
            }
            case '&': {
                return InstructionConst.LAND;
            }
            case '|': {
                return InstructionConst.LOR;
            }
            case '^': {
                return InstructionConst.LXOR;
            }
            case '<': {
                return InstructionConst.LSHL;
            }
            case '>': {
                return op.equals(">>>") ? InstructionConst.LUSHR : InstructionConst.LSHR;
            }
        }
        throw new RuntimeException("Invalid operand " + op);
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArithmeticInstruction createBinaryFloatOp(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char op) {
        switch (op) {
            case '-': {
                return InstructionConst.FSUB;
            }
            case '+': {
                return InstructionConst.FADD;
            }
            case '*': {
                return InstructionConst.FMUL;
            }
            case '/': {
                return InstructionConst.FDIV;
            }
            case '%': {
                return InstructionConst.FREM;
            }
        }
        throw new RuntimeException("Invalid operand " + op);
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArithmeticInstruction createBinaryDoubleOp(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown char op) {
        switch (op) {
            case '-': {
                return InstructionConst.DSUB;
            }
            case '+': {
                return InstructionConst.DADD;
            }
            case '*': {
                return InstructionConst.DMUL;
            }
            case '/': {
                return InstructionConst.DDIV;
            }
            case '%': {
                return InstructionConst.DREM;
            }
        }
        throw new RuntimeException("Invalid operand " + op);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArithmeticInstruction createBinaryOperation(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String op, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        char first = op.charAt(0);
        switch (type.getType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionFactory.createBinaryIntOp(first, op);
            }
            case 11: {
                return InstructionFactory.createBinaryLongOp(first, op);
            }
            case 6: {
                return InstructionFactory.createBinaryFloatOp(first);
            }
            case 7: {
                return InstructionFactory.createBinaryDoubleOp(first);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackInstruction createPop(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size) {
        return size == 2 ? InstructionConst.POP2 : InstructionConst.POP;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackInstruction createDup(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size) {
        return size == 2 ? InstructionConst.DUP2 : InstructionConst.DUP;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackInstruction createDup_2(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size) {
        return size == 2 ? InstructionConst.DUP2_X2 : InstructionConst.DUP_X2;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackInstruction createDup_1(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int size) {
        return size == 2 ? InstructionConst.DUP2_X1 : InstructionConst.DUP_X1;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInstruction createStore(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ISTORE(index);
            }
            case 6: {
                return new FSTORE(index);
            }
            case 7: {
                return new DSTORE(index);
            }
            case 11: {
                return new LSTORE(index);
            }
            case 13: 
            case 14: {
                return new ASTORE(index);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown LocalVariableInstruction createLoad(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int index) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ILOAD(index);
            }
            case 6: {
                return new FLOAD(index);
            }
            case 7: {
                return new DLOAD(index);
            }
            case 11: {
                return new LLOAD(index);
            }
            case 13: 
            case 14: {
                return new ALOAD(index);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayInstruction createArrayLoad(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConst.BALOAD;
            }
            case 5: {
                return InstructionConst.CALOAD;
            }
            case 9: {
                return InstructionConst.SALOAD;
            }
            case 10: {
                return InstructionConst.IALOAD;
            }
            case 6: {
                return InstructionConst.FALOAD;
            }
            case 7: {
                return InstructionConst.DALOAD;
            }
            case 11: {
                return InstructionConst.LALOAD;
            }
            case 13: 
            case 14: {
                return InstructionConst.AALOAD;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ArrayInstruction createArrayStore(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConst.BASTORE;
            }
            case 5: {
                return InstructionConst.CASTORE;
            }
            case 9: {
                return InstructionConst.SASTORE;
            }
            case 10: {
                return InstructionConst.IASTORE;
            }
            case 6: {
                return InstructionConst.FASTORE;
            }
            case 7: {
                return InstructionConst.DASTORE;
            }
            case 11: {
                return InstructionConst.LASTORE;
            }
            case 13: 
            case 14: {
                return InstructionConst.AASTORE;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction createCast(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type src_type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type dest_type) {
        if (src_type instanceof BasicType && dest_type instanceof BasicType) {
            byte dest = dest_type.getType();
            int src = src_type.getType();
            if (dest == 11 && (src == 5 || src == 8 || src == 9)) {
                src = 10;
            }
            @ClassGetName String name = "randoop.org.apache.bcel.generic." + short_names[src - 5] + "2" + short_names[dest - 5];
            Instruction i = null;
            try {
                i = (Instruction)Class.forName(name).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find instruction: " + name, e);
            }
            return i;
        }
        if (src_type instanceof ReferenceType && dest_type instanceof ReferenceType) {
            if (dest_type instanceof ArrayType) {
                return new CHECKCAST(this.cp.addArrayClass((ArrayType)dest_type));
            }
            return new CHECKCAST(this.cp.addClass(((ObjectType)dest_type).getClassName()));
        }
        throw new RuntimeException("Can not cast " + src_type + " to " + dest_type);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GETFIELD createGetField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type t) {
        return new GETFIELD(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown GETSTATIC createGetStatic(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type t) {
        return new GETSTATIC(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PUTFIELD createPutField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type t) {
        return new PUTFIELD(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown PUTSTATIC createPutStatic(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type t) {
        return new PUTSTATIC(this.cp.addFieldref(class_name, name, t.getSignature()));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CHECKCAST createCheckCast(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReferenceType t) {
        if (t instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)t));
        }
        return new CHECKCAST(this.cp.addClass((ObjectType)t));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown INSTANCEOF createInstanceOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ReferenceType t) {
        if (t instanceof ArrayType) {
            return new INSTANCEOF(this.cp.addArrayClass((ArrayType)t));
        }
        return new INSTANCEOF(this.cp.addClass((ObjectType)t));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NEW createNew(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ObjectType t) {
        return new NEW(this.cp.addClass(t));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NEW createNew(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s2) {
        return this.createNew(ObjectType.getInstance(s2));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction createNewArray(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type t, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short dim) {
        if (dim == 1) {
            if (t instanceof ObjectType) {
                return new ANEWARRAY(this.cp.addClass((ObjectType)t));
            }
            if (t instanceof ArrayType) {
                return new ANEWARRAY(this.cp.addArrayClass((ArrayType)t));
            }
            return new NEWARRAY(t.getType());
        }
        ArrayType at = t instanceof ArrayType ? (ArrayType)t : new ArrayType(t, (int)dim);
        return new MULTIANEWARRAY(this.cp.addArrayClass(at), dim);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Instruction createNull(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConst.ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConst.ICONST_0;
            }
            case 6: {
                return InstructionConst.FCONST_0;
            }
            case 7: {
                return InstructionConst.DCONST_0;
            }
            case 11: {
                return InstructionConst.LCONST_0;
            }
            case 12: {
                return InstructionConst.NOP;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown BranchInstruction createBranchInstruction(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown short opcode, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown InstructionHandle target) {
        switch (opcode) {
            case 153: {
                return new IFEQ(target);
            }
            case 154: {
                return new IFNE(target);
            }
            case 155: {
                return new IFLT(target);
            }
            case 156: {
                return new IFGE(target);
            }
            case 157: {
                return new IFGT(target);
            }
            case 158: {
                return new IFLE(target);
            }
            case 159: {
                return new IF_ICMPEQ(target);
            }
            case 160: {
                return new IF_ICMPNE(target);
            }
            case 161: {
                return new IF_ICMPLT(target);
            }
            case 162: {
                return new IF_ICMPGE(target);
            }
            case 163: {
                return new IF_ICMPGT(target);
            }
            case 164: {
                return new IF_ICMPLE(target);
            }
            case 165: {
                return new IF_ACMPEQ(target);
            }
            case 166: {
                return new IF_ACMPNE(target);
            }
            case 167: {
                return new GOTO(target);
            }
            case 168: {
                return new JSR(target);
            }
            case 198: {
                return new IFNULL(target);
            }
            case 199: {
                return new IFNONNULL(target);
            }
            case 200: {
                return new GOTO_W(target);
            }
            case 201: {
                return new JSR_W(target);
            }
        }
        throw new RuntimeException("Invalid opcode: " + opcode);
    }

    public void setClassGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ClassGen c) {
        this.cg = c;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ClassGen getClassGen() {
        return this.cg;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen c) {
        this.cp = c;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    private static class MethodObject {
        final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] arg_types;
        final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type result_type;
        final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String class_name;
        final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name;

        MethodObject(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String c, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String n, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type r, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] a) {
            this.class_name = c;
            this.name = n;
            this.result_type = r;
            this.arg_types = a;
        }
    }
}

