/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.StackMapEntry;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class StackMap
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] map;

    public StackMap(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] map, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.map = map;
    }

    StackMap(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (StackMapEntry[])null, constant_pool);
        int map_length = input.readUnsignedShort();
        this.map = new StackMapEntry[map_length];
        for (int i = 0; i < map_length; ++i) {
            this.map[i] = new StackMapEntry(input, constant_pool);
        }
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.map.length);
        for (StackMapEntry entry : this.map) {
            entry.dump(file);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getStackMap() {
        return this.map;
    }

    public void setStackMap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StackMapEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] map) {
        this.map = map;
        int len = 2;
        for (StackMapEntry element : map) {
            len += element.getMapEntrySize();
        }
        this.setLength(len);
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder("StackMap(");
        for (int i = 0; i < this.map.length; ++i) {
            buf.append(this.map[i]);
            if (i >= this.map.length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        StackMap c = (StackMap)this.clone();
        c.map = new StackMapEntry[this.map.length];
        for (int i = 0; i < this.map.length; ++i) {
            c.map[i] = this.map[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitStackMap(this);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getMapLength() {
        return this.map == null ? 0 : this.map.length;
    }
}

