/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.ConstantUtf8;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class Signature
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index;

    public Signature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Signature c) {
        this(c.getNameIndex(), c.getLength(), c.getSignatureIndex(), c.getConstantPool());
    }

    Signature(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, input.readUnsignedShort(), constant_pool);
    }

    public Signature(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)10, name_index, length, constant_pool);
        this.signature_index = signature_index;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitSignature(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.signature_index);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getSignatureIndex() {
        return this.signature_index;
    }

    public void setSignatureIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int signature_index) {
        this.signature_index = signature_index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getSignature() {
        ConstantUtf8 c = (ConstantUtf8)super.getConstantPool().getConstant(this.signature_index, (byte)1);
        return c.getBytes();
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean identStart(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int ch) {
        return ch == 84 || ch == 76;
    }

    private static void matchIdent(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MyByteArrayInputStream in, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StringBuilder buf) {
        int ch = in.read();
        if (ch == -1) {
            throw new RuntimeException("Illegal signature: " + in.getData() + " no ident, reaching EOF");
        }
        if (!Signature.identStart(ch)) {
            StringBuilder buf2 = new StringBuilder();
            int count = 1;
            while (Character.isJavaIdentifierPart((char)ch)) {
                buf2.append((char)ch);
                ++count;
                ch = in.read();
            }
            if (ch == 58) {
                in.skip("Ljava/lang/Object".length());
                buf.append((CharSequence)buf2);
                ch = in.read();
                in.unread();
            } else {
                for (int i = 0; i < count; ++i) {
                    in.unread();
                }
            }
            return;
        }
        StringBuilder buf2 = new StringBuilder();
        ch = in.read();
        do {
            buf2.append((char)ch);
        } while ((ch = in.read()) != -1 && (Character.isJavaIdentifierPart((char)ch) || ch == 47));
        buf.append(buf2.toString().replace('/', '.'));
        if (ch != -1) {
            in.unread();
        }
    }

    private static void matchGJIdent(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MyByteArrayInputStream in, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown StringBuilder buf) {
        Signature.matchIdent(in, buf);
        int ch = in.read();
        if (ch == 60 || ch == 40) {
            buf.append((char)ch);
            Signature.matchGJIdent(in, buf);
            while ((ch = in.read()) != 62 && ch != 41) {
                if (ch == -1) {
                    throw new RuntimeException("Illegal signature: " + in.getData() + " reaching EOF");
                }
                buf.append(", ");
                in.unread();
                Signature.matchGJIdent(in, buf);
            }
            buf.append((char)ch);
        } else {
            in.unread();
        }
        ch = in.read();
        if (Signature.identStart(ch)) {
            in.unread();
            Signature.matchGJIdent(in, buf);
        } else {
            if (ch == 41) {
                in.unread();
                return;
            }
            if (ch != 59) {
                throw new RuntimeException("Illegal signature: " + in.getData() + " read " + (char)ch);
            }
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String translate(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s2) {
        StringBuilder buf = new StringBuilder();
        Signature.matchGJIdent(new MyByteArrayInputStream(s2), buf);
        return buf.toString();
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isFormalParameterList(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s2) {
        return s2.startsWith("<") && s2.indexOf(58) > 0;
    }

    public static @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isActualParameterList(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String s2) {
        return s2.startsWith("L") && s2.endsWith(">;");
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        String s2 = this.getSignature();
        return "Signature: " + s2;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        return (Attribute)this.clone();
    }

    private static final class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String data) {
            super(data.getBytes());
        }

        @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getData() {
            return new String(this.buf);
        }

        void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }
}

