/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.Utility;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class NestMembers
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] classes;

    public NestMembers(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown NestMembers c) {
        this(c.getNameIndex(), c.getLength(), c.getClasses(), c.getConstantPool());
    }

    public NestMembers(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] classes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        super((byte)26, name_index, length, constant_pool);
        this.classes = classes != null ? classes : new int[]{};
    }

    NestMembers(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(name_index, length, (int[])null, constant_pool);
        int number_of_classes = input.readUnsignedShort();
        this.classes = new int[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            this.classes[i] = input.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitNestMembers(this);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.classes.length);
        for (int index : this.classes) {
            file.writeShort(index);
        }
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getClasses() {
        return this.classes;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumberClasses() {
        return this.classes == null ? 0 : this.classes.length;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getClassNames() {
        String[] names = new String[this.classes.length];
        for (int i = 0; i < this.classes.length; ++i) {
            names[i] = super.getConstantPool().getConstantString(this.classes[i], (byte)7).replace('/', '.');
        }
        return names;
    }

    public void setClasses(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] classes) {
        this.classes = classes != null ? classes : new int[]{};
    }

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("NestMembers(");
        buf.append(this.classes.length);
        buf.append("):\n");
        for (int index : this.classes) {
            String class_name = super.getConstantPool().getConstantString(index, (byte)7);
            buf.append("  ").append(Utility.compactClassName(class_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool _constant_pool) {
        NestMembers c = (NestMembers)this.clone();
        if (this.classes != null) {
            c.classes = new int[this.classes.length];
            System.arraycopy(this.classes, 0, c.classes, 0, this.classes.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

