/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.Node;
import randoop.org.apache.bcel.classfile.Utility;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class ModuleExports
implements Cloneable,
Node {
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int exports_index;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int exports_flags;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int exports_to_count;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] exports_to_index;

    ModuleExports(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.exports_index = file.readUnsignedShort();
        this.exports_flags = file.readUnsignedShort();
        this.exports_to_count = file.readUnsignedShort();
        this.exports_to_index = new int[this.exports_to_count];
        for (int i = 0; i < this.exports_to_count; ++i) {
            this.exports_to_index[i] = file.readUnsignedShort();
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitModuleExports(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.exports_index);
        file.writeShort(this.exports_flags);
        file.writeShort(this.exports_to_count);
        for (int entry : this.exports_to_index) {
            file.writeShort(entry);
        }
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "exports(" + this.exports_index + ", " + this.exports_flags + ", " + this.exports_to_count + ", ...)";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        StringBuilder buf = new StringBuilder();
        String package_name = constant_pool.constantToString(this.exports_index, (byte)20);
        buf.append(Utility.compactClassName(package_name, false));
        buf.append(", ").append(String.format("%04x", this.exports_flags));
        buf.append(", to(").append(this.exports_to_count).append("):\n");
        for (int index : this.exports_to_index) {
            String module_name = constant_pool.getConstantString(index, (byte)19);
            buf.append("      ").append(Utility.compactClassName(module_name, false)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ModuleExports copy() {
        try {
            return (ModuleExports)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

