/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantClass;
import randoop.org.apache.bcel.classfile.ConstantNameAndType;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class EnclosingMethod
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int classIndex;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int methodIndex;

    EnclosingMethod(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int len, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(nameIndex, len, input.readUnsignedShort(), input.readUnsignedShort(), cpool);
    }

    private EnclosingMethod(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIndex, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int len, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int classIdx, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int methodIdx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cpool) {
        super((byte)18, nameIndex, len, cpool);
        this.classIndex = classIdx;
        this.methodIndex = methodIdx;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitEnclosingMethod(this);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        return (Attribute)this.clone();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getEnclosingClassIndex() {
        return this.classIndex;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getEnclosingMethodIndex() {
        return this.methodIndex;
    }

    public final void setEnclosingClassIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int idx) {
        this.classIndex = idx;
    }

    public final void setEnclosingMethodIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int idx) {
        this.methodIndex = idx;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantClass getEnclosingClass() {
        ConstantClass c = (ConstantClass)super.getConstantPool().getConstant(this.classIndex, (byte)7);
        return c;
    }

    public final @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown ConstantNameAndType getEnclosingMethod() {
        if (this.methodIndex == 0) {
            return null;
        }
        ConstantNameAndType nat = (ConstantNameAndType)super.getConstantPool().getConstant(this.methodIndex, (byte)12);
        return nat;
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        super.dump(file);
        file.writeShort(this.classIndex);
        file.writeShort(this.methodIndex);
    }
}

