/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.Constants;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.Node;
import randoop.org.apache.bcel.classfile.Utility;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public final class CodeException
implements Cloneable,
Node,
Constants {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int end_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int handler_pc;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int catch_type;

    public CodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException c) {
        this(c.getStartPC(), c.getEndPC(), c.getHandlerPC(), c.getCatchType());
    }

    CodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort());
    }

    public CodeException(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int end_pc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int handler_pc, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int catch_type) {
        this.start_pc = start_pc;
        this.end_pc = end_pc;
        this.handler_pc = handler_pc;
        this.catch_type = catch_type;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitCodeException(this);
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.start_pc);
        file.writeShort(this.end_pc);
        file.writeShort(this.handler_pc);
        file.writeShort(this.catch_type);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getCatchType() {
        return this.catch_type;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getEndPC() {
        return this.end_pc;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getHandlerPC() {
        return this.handler_pc;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getStartPC() {
        return this.start_pc;
    }

    public void setCatchType(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int catch_type) {
        this.catch_type = catch_type;
    }

    public void setEndPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int end_pc) {
        this.end_pc = end_pc;
    }

    public void setHandlerPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int handler_pc) {
        this.handler_pc = handler_pc;
    }

    public void setStartPC(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int start_pc) {
        this.start_pc = start_pc;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "CodeException(start_pc = " + this.start_pc + ", end_pc = " + this.end_pc + ", handler_pc = " + this.handler_pc + ", catch_type = " + this.catch_type + ")";
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean verbose) {
        String str = this.catch_type == 0 ? "<Any exception>(0)" : Utility.compactClassName(cp.getConstantString(this.catch_type, (byte)7), false) + (verbose ? "(" + this.catch_type + ")" : "");
        return this.start_pc + "\t" + this.end_pc + "\t" + this.handler_pc + "\t" + str;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool cp) {
        return this.toString(cp, true);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown CodeException copy() {
        try {
            return (CodeException)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

