/*
 * Decompiled with CFR 0.152.
 */
package randoop.org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import randoop.org.apache.bcel.classfile.AnnotationEntry;
import randoop.org.apache.bcel.classfile.Attribute;
import randoop.org.apache.bcel.classfile.ConstantPool;
import randoop.org.apache.bcel.classfile.Visitor;
import randoop.org.checkerframework.checker.initialization.qual.Initialized;
import randoop.org.checkerframework.checker.interning.qual.Interned;
import randoop.org.checkerframework.checker.interning.qual.UnknownInterned;
import randoop.org.checkerframework.checker.nullness.qual.NonNull;
import randoop.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public abstract class Annotations
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] annotation_table;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible;

    Annotations(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte annotation_type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this(annotation_type, name_index, length, (AnnotationEntry[])null, constant_pool, isRuntimeVisible);
        int annotation_table_length = input.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[annotation_table_length];
        for (int i = 0; i < annotation_table_length; ++i) {
            this.annotation_table[i] = AnnotationEntry.read(input, constant_pool, isRuntimeVisible);
        }
    }

    public Annotations(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown byte annotation_type, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] annotation_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible) {
        super(annotation_type, name_index, length, constant_pool);
        this.annotation_table = annotation_table;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown Visitor v) {
        v.visitAnnotation(this);
    }

    public final void setAnnotationTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] annotation_table) {
        this.annotation_table = annotation_table;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown [] getAnnotationEntries() {
        return this.annotation_table;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNumAnnotations() {
        if (this.annotation_table == null) {
            return 0;
        }
        return this.annotation_table.length;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    protected void writeAnnotations(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        if (this.annotation_table == null) {
            return;
        }
        dos.writeShort(this.annotation_table.length);
        for (AnnotationEntry element : this.annotation_table) {
            element.dump(dos);
        }
    }
}

