/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.util.List;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.sequence.Variable;
import randoop.types.Type;
import randoop.types.TypeTuple;

class UncheckedCast
extends CallableOperation {
    private final @SignatureUnknown Type type;

    UncheckedCast(@SignatureUnknown Type type) {
        this.type = type;
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] input) {
        assert (input.length == 1) : "cast only takes one input";
        return new NormalExecution(this.type.getRuntimeClass().cast(input[0]), 0L);
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        b.append("(").append(this.type.getFqName()).append(")");
        int i = 0;
        String param = this.getArgumentString(inputVars.get(i));
        b.append(param);
    }

    @Override
    public @SignatureUnknown boolean isUncheckedCast() {
        return true;
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        return "(" + this.type.getBinaryName() + ")" + inputTypes.get(0);
    }

    @Override
    public @SignatureUnknown String getName() {
        return "(" + this.type.getBinaryName() + ")";
    }
}

