/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import randoop.operation.CallableOperation;
import randoop.operation.ConstructorCall;
import randoop.operation.MethodCall;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.UtilPlume;
import randoop.reflection.RawSignature;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.types.TypeVariable;

public class TypedClassOperation
extends TypedOperation {
    private final @SignatureUnknown ClassOrInterfaceType declaringType;
    private @SignatureUnknown RawSignature rawSignature = null;

    public TypedClassOperation(@SignatureUnknown CallableOperation operation, @SignatureUnknown ClassOrInterfaceType declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        super(operation, inputTypes, outputType);
        this.declaringType = declaringType;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypedClassOperation)) {
            return false;
        }
        TypedClassOperation op = (TypedClassOperation)obj;
        return this.declaringType.equals(op.declaringType) && super.equals(obj);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(super.hashCode(), this.declaringType);
    }

    public @SignatureUnknown ClassOrInterfaceType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public @SignatureUnknown TypedClassOperation substitute(@SignatureUnknown Substitution substitution) {
        if (substitution.isEmpty()) {
            return this;
        }
        ClassOrInterfaceType declaringType = this.declaringType.substitute(substitution);
        TypeTuple inputTypes = this.getInputTypes().substitute(substitution);
        Type outputType = this.getOutputType().substitute(substitution);
        return new TypedClassOperation(this.getOperation(), declaringType, inputTypes, outputType);
    }

    @Override
    public @SignatureUnknown TypedClassOperation applyCaptureConversion() {
        TypeTuple inputTypes = this.getInputTypes().applyCaptureConversion();
        Type outputType = this.getOutputType();
        return new TypedClassOperation(this.getOperation(), this.declaringType, inputTypes, outputType);
    }

    @Override
    public void appendCode(@SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        assert (inputVars.size() == this.getInputTypes().size()) : "number of inputs doesn't match on operation appendCode";
        this.getOperation().appendCode(this.declaringType, this.getInputTypes(), this.getOutputType(), inputVars, b);
    }

    @Override
    public @SignatureUnknown String toParsableString() {
        return this.getOperation().toParsableString(this.declaringType, this.getInputTypes(), this.getOutputType());
    }

    @Override
    @SideEffectFree
    public @SignatureUnknown String toString() {
        if (this.isGeneric()) {
            String b = "<" + UtilPlume.join((CharSequence)",", this.getTypeParameters()) + "> ";
            return b + super.toString();
        }
        return super.toString();
    }

    @Override
    public @SignatureUnknown String getName() {
        return this.declaringType + "." + super.getName();
    }

    public @SignatureUnknown String getUnqualifiedBinaryName() {
        return super.getName();
    }

    @Override
    public @SignatureUnknown boolean hasWildcardTypes() {
        return this.getInputTypes().hasWildcard() || this.getOutputType().isParameterized() && ((ClassOrInterfaceType)this.getOutputType()).hasWildcard();
    }

    @Override
    public @SignatureUnknown List<@SignatureUnknown TypeVariable> getTypeParameters() {
        LinkedHashSet<TypeVariable> paramSet = new LinkedHashSet<TypeVariable>();
        paramSet.addAll(this.getInputTypes().getTypeParameters());
        if (this.getOutputType().isReferenceType()) {
            paramSet.addAll(((ReferenceType)this.getOutputType()).getTypeParameters());
        }
        return new ArrayList<TypeVariable>(paramSet);
    }

    public @SignatureUnknown String getFullyQualifiedSignature() {
        if (!this.isConstructorCall() && !this.isMethodCall()) {
            return null;
        }
        Package classPackage = this.declaringType.getPackage();
        String packageName = classPackage == null ? null : classPackage.getName();
        String classname = this.getDeclaringType().getRawtype().getUnqualifiedBinaryName();
        String name = this.getUnqualifiedBinaryName().equals("<init>") ? classname : this.getUnqualifiedBinaryName();
        Iterator<Type> inputTypeIterator = this.inputTypes.iterator();
        ArrayList<String> typeNames = new ArrayList<String>();
        int i = 0;
        while (inputTypeIterator.hasNext()) {
            String typeName = inputTypeIterator.next().getFqName();
            if (this.isStatic() || i != 0) {
                typeNames.add(typeName);
            }
            ++i;
        }
        return (packageName == null ? "" : packageName + ".") + (classname.equals(name) ? name : classname + "." + name) + "(" + UtilPlume.join((CharSequence)",", typeNames) + ")";
    }

    public @SignatureUnknown RawSignature getRawSignature() {
        if (!this.isConstructorCall() && !this.isMethodCall()) {
            return null;
        }
        if (this.rawSignature == null) {
            Package classPackage = this.declaringType.getPackage();
            String packageName = classPackage == null ? null : classPackage.getName();
            String classname = this.getDeclaringType().getRawtype().getUnqualifiedBinaryName();
            String name = this.getUnqualifiedBinaryName().equals("<init>") ? classname : this.getUnqualifiedBinaryName();
            Class<?>[] parameterTypes = this.isMethodCall() ? ((MethodCall)this.getOperation()).getMethod().getParameterTypes() : ((ConstructorCall)this.getOperation()).getConstructor().getParameterTypes();
            this.rawSignature = new RawSignature(packageName, classname, name, parameterTypes);
        }
        return this.rawSignature;
    }

    public @SignatureUnknown TypedClassOperation getOperationForType(@SignatureUnknown ClassOrInterfaceType type) {
        if (type == this.getDeclaringType()) {
            return this;
        }
        return new TypedClassOperation(this.getOperation(), type, this.getInputTypes(), this.getOutputType());
    }
}

