/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.lang.reflect.Array;
import java.util.List;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Variable;
import randoop.types.ArrayType;
import randoop.types.Type;
import randoop.types.TypeTuple;

public class ReflectionArrayCreation
extends CallableOperation {
    private final @SignatureUnknown Type elementType;
    private final @SignatureUnknown int length;

    public ReflectionArrayCreation(@SignatureUnknown ArrayType arrayType, @SignatureUnknown int length) {
        this.elementType = arrayType.getComponentType();
        this.length = length;
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] input) {
        long startTime = System.currentTimeMillis();
        assert (input.length == 0);
        Object arrayObject = Array.newInstance(this.elementType.getRuntimeClass(), this.length);
        long totalTime = System.currentTimeMillis() - startTime;
        return new NormalExecution(arrayObject, totalTime);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "Array.newInstance(" + this.elementType.getBinaryName() + ", " + this.length + ")";
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        b.append("Array.newInstance(").append(this.elementType.getCanonicalName()).append(", ").append(this.length).append(")");
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        return null;
    }

    @Override
    public @SignatureUnknown String getName() {
        return this.toString();
    }
}

