/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import randoop.operation.ConstructorCall;
import randoop.operation.EnumConstant;
import randoop.operation.FieldGet;
import randoop.operation.FieldSet;
import randoop.operation.InitializedArrayCreation;
import randoop.operation.MethodCall;
import randoop.operation.NonreceiverTerm;
import randoop.operation.OperationParseException;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class OperationParser {
    private OperationParser() {
        throw new Error("Do not instantiate");
    }

    public static @SignatureUnknown TypedOperation parse(@SignatureUnknown String str) throws @SignatureUnknown OperationParseException {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("invalid string: " + str);
        }
        int colonIdx = str.indexOf(58);
        if (colonIdx == -1) {
            String msg = "A statement description must be of the form <id> : <description> but the statement \"" + str + "\" does not have a valid form (no colon).";
            throw new OperationParseException(msg);
        }
        String id = str.substring(0, colonIdx).trim();
        String descr = str.substring(colonIdx + 1).trim();
        if (id.equals("NonreceiverTerm")) {
            return NonreceiverTerm.parse(descr);
        }
        if (id.equals("MethodCall")) {
            return MethodCall.parse(descr);
        }
        if (id.equals("ConstructorCall")) {
            return ConstructorCall.parse(descr);
        }
        if (id.equals("InitializedArrayCreation")) {
            return InitializedArrayCreation.parse(descr);
        }
        if (id.equals("EnumConstant")) {
            return EnumConstant.parse(descr);
        }
        if (id.equals("FieldGet")) {
            return FieldGet.parse(descr);
        }
        if (id.equals("FieldSet")) {
            return FieldSet.parse(descr);
        }
        throw new OperationParseException("Invalid id \"" + id + "\" in statement: " + str);
    }
}

