/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.util.List;
import java.util.Objects;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypedOperation;
import randoop.operation.TypedTermOperation;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.UtilPlume;
import randoop.sequence.StringTooLongException;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.PrimitiveTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class NonreceiverTerm
extends CallableOperation {
    private final @SignatureUnknown Type type;
    private final @SignatureUnknown Object value;

    public NonreceiverTerm(@SignatureUnknown Type type, @SignatureUnknown Object value) {
        if (type == null) {
            throw new IllegalArgumentException("type should not be null.");
        }
        if (type.isVoid()) {
            throw new IllegalArgumentException("type should not be void.");
        }
        if (type.isPrimitive() || type.isBoxedPrimitive()) {
            if (value == null) {
                if (type.isPrimitive()) {
                    throw new IllegalArgumentException("primitive-like values cannot be null.");
                }
            } else {
                if (!type.isAssignableFromTypeOf(value)) {
                    throw new IllegalArgumentException("value.getClass()=" + value.getClass() + ",type=" + type);
                }
                if (!NonreceiverTerm.isNonreceiverType(value.getClass())) {
                    throw new IllegalArgumentException("value is not a primitive-like value.");
                }
            }
        } else if (type.isString()) {
            String s2 = (String)value;
            if (value != null && !Value.escapedStringLengthOk(s2)) {
                throw new StringTooLongException(s2);
            }
        } else if (!type.equals(JavaTypes.CLASS_TYPE) && value != null) {
            throw new IllegalArgumentException("value must be null for type " + type + " but was " + value);
        }
        this.type = type;
        this.value = value;
    }

    public static @SignatureUnknown boolean isNonreceiverType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> c) {
        return c.isPrimitive() || c.equals(String.class) || PrimitiveTypes.isBoxedPrimitive(c) || c.equals(Class.class);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonreceiverTerm)) {
            return false;
        }
        NonreceiverTerm other = (NonreceiverTerm)o;
        return this.type.equals(other.type) && Objects.equals(this.value, other.value);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return this.type.hashCode() + (this.value == null ? 0 : this.value.hashCode());
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        if (this.type.equals(JavaTypes.CLASS_TYPE)) {
            return ((Class)this.value).getName() + ".class";
        }
        return Objects.toString(this.value);
    }

    @Override
    public @SignatureUnknown String getName() {
        return this.toString();
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] statementInput) {
        assert (statementInput.length == 0);
        return new NormalExecution(this.value, 0L);
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        b.append(Value.toCodeString(this.getValue()));
    }

    @Override
    public @SignatureUnknown Object getValue() {
        return this.value;
    }

    public @SignatureUnknown Type getType() {
        return this.type;
    }

    static @SignatureUnknown NonreceiverTerm createNullOrZeroTerm(@SignatureUnknown Type type) {
        if (type.isBoxedPrimitive()) {
            type = ((NonParameterizedType)type).toPrimitive();
        }
        if (type.isString()) {
            return new NonreceiverTerm(type, "");
        }
        if (type.equals(JavaTypes.CHAR_TYPE)) {
            return new NonreceiverTerm(type, Character.valueOf('a'));
        }
        if (type.equals(JavaTypes.BYTE_TYPE)) {
            return new NonreceiverTerm(type, (byte)0);
        }
        if (type.equals(JavaTypes.SHORT_TYPE)) {
            return new NonreceiverTerm(type, (short)0);
        }
        if (type.equals(JavaTypes.INT_TYPE)) {
            return new NonreceiverTerm(type, 0);
        }
        if (type.equals(JavaTypes.LONG_TYPE)) {
            return new NonreceiverTerm(type, 0L);
        }
        if (type.equals(JavaTypes.FLOAT_TYPE)) {
            return new NonreceiverTerm(type, Float.valueOf(0.0f));
        }
        if (type.equals(JavaTypes.DOUBLE_TYPE)) {
            return new NonreceiverTerm(type, 0.0);
        }
        if (type.equals(JavaTypes.BOOLEAN_TYPE)) {
            return new NonreceiverTerm(type, false);
        }
        return new NonreceiverTerm(type, null);
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        String valStr;
        if (this.value == null) {
            valStr = "null";
        } else if (this.type.equals(JavaTypes.CHAR_TYPE)) {
            valStr = Integer.toHexString(((Character)this.value).charValue());
        } else if (this.type.equals(JavaTypes.CLASS_TYPE)) {
            valStr = ((Class)this.value).getName() + ".class";
        } else {
            valStr = this.value.toString();
            if (this.type.isString()) {
                valStr = "\"" + UtilPlume.escapeJava(valStr) + "\"";
            }
        }
        return this.type.getBinaryName() + ":" + valStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @SignatureUnknown TypedOperation parse(@SignatureUnknown String s2) throws @SignatureUnknown OperationParseException {
        Object value;
        Type type;
        if (s2 == null) {
            throw new IllegalArgumentException("s cannot be null.");
        }
        int colonIdx = s2.indexOf(58);
        if (colonIdx == -1) {
            String msg = "A primitive value declaration description must be of the form <type>:<value> but the description \"" + s2 + "\" does not have this form.";
            throw new OperationParseException(msg);
        }
        String typeString = s2.substring(0, colonIdx);
        String valString = s2.substring(colonIdx + 1);
        if (typeString.matches(".*\\s+.*")) {
            String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <type> description \"" + s2 + "\" contains whitespace characters.";
            throw new OperationParseException(msg);
        }
        if (typeString.equals("String")) {
            typeString = "java.lang.String";
        }
        try {
            type = Type.forName(typeString);
        }
        catch (ClassNotFoundException e1) {
            String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <type> given (\"" + typeString + "\") was unrecognized.";
            throw new OperationParseException(msg);
        }
        if (type.equals(JavaTypes.CHAR_TYPE)) {
            try {
                value = Character.valueOf((char)Integer.parseInt(valString, 16));
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.BYTE_TYPE)) {
            try {
                value = Byte.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.SHORT_TYPE)) {
            try {
                value = Short.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.INT_TYPE)) {
            try {
                value = Integer.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.LONG_TYPE)) {
            try {
                value = Long.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.FLOAT_TYPE)) {
            try {
                value = Float.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.DOUBLE_TYPE)) {
            try {
                value = Double.valueOf(valString);
            }
            catch (NumberFormatException e) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
        }
        if (type.equals(JavaTypes.BOOLEAN_TYPE)) {
            if (!valString.equals("true") && !valString.equals("false")) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description must be of the form <type>:<value> but the <value> given (\"" + valString + "\") was not parsable.";
                throw new OperationParseException(msg);
            }
            value = Boolean.valueOf(valString);
        } else if (type.isString()) {
            if (valString.equals("null")) {
                value = null;
            } else {
                if (valString.charAt(0) != '\"' || valString.charAt(valString.length() - 1) != '\"') {
                    String msg = "Error when parsing type/value pair " + s2 + ". A String value declaration description must be of the form java.lang.String:\"thestring\" but the string given was not enclosed in quotation marks.";
                    throw new OperationParseException(msg);
                }
                String valStringContent = valString.substring(1, valString.length() - 1);
                if (!Value.stringLengthOk(valStringContent)) {
                    throw new OperationParseException(String.format("Error when parsing String; length %d is too large", valStringContent.length()));
                }
                value = UtilPlume.unescapeJava(valStringContent);
            }
        } else {
            if (!valString.equals("null")) {
                String msg = "Error when parsing type/value pair " + s2 + ". A primitive value declaration description that is not a primitive value or a string must be of the form <type>:null but the string given (\"" + valString + "\") was not of this form.";
                throw new OperationParseException(msg);
            }
            value = null;
        }
        NonreceiverTerm nonreceiverTerm = new NonreceiverTerm(type, value);
        return new TypedTermOperation(nonreceiverTerm, new TypeTuple(), type);
    }

    @Override
    public @SignatureUnknown boolean isNonreceivingValue() {
        return true;
    }
}

