/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.util.List;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypedClassOperation;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.types.TypeTuple;

public class EnumConstant
extends CallableOperation {
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Enum<@SignatureUnknown @SignatureBottom ?> value;

    public EnumConstant(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Enum<@SignatureUnknown @SignatureBottom ?> value) {
        if (value == null) {
            throw new IllegalArgumentException("enum constant cannot be null");
        }
        this.value = value;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumConstant)) {
            return false;
        }
        EnumConstant e = (EnumConstant)obj;
        return this.equalsEnumConstant(e);
    }

    public @SignatureUnknown boolean equalsEnumConstant(@SignatureUnknown EnumConstant e) {
        return this.value.equals(e.value);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return this.value.hashCode();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.value.toString();
    }

    @Override
    public @SignatureUnknown String getName() {
        return this.value.name();
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] statementInput) {
        assert (statementInput.length == 0);
        return new NormalExecution(this.value, 0L);
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        b.append(declaringType.getFqName()).append(".").append(this.value.name());
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        return declaringType.getBinaryName() + ":" + this.value.name();
    }

    public static @SignatureUnknown TypedClassOperation parse(@SignatureUnknown String desc) throws @SignatureUnknown OperationParseException {
        Type declaringType;
        if (desc == null) {
            throw new IllegalArgumentException("desc cannot be null");
        }
        int colonIdx = desc.indexOf(58);
        if (colonIdx < 0) {
            String msg = "An enum constant description must be of the form \"<type>:<value> but description is \"" + desc + "\".";
            throw new OperationParseException(msg);
        }
        String typeName = desc.substring(0, colonIdx).trim();
        String valueName = desc.substring(colonIdx + 1).trim();
        String errorPrefix = "Error when parsing type-value pair " + desc + " for an enum description of the form <type>:<value>.";
        if (typeName.isEmpty()) {
            String msg = errorPrefix + " No type given.";
            throw new OperationParseException(msg);
        }
        if (valueName.isEmpty()) {
            String msg = errorPrefix + " No value given.";
            throw new OperationParseException(msg);
        }
        String whitespacePattern = ".*\\s+.*";
        if (typeName.matches(whitespacePattern)) {
            String msg = errorPrefix + " The type has unexpected whitespace characters.";
            throw new OperationParseException(msg);
        }
        if (valueName.matches(whitespacePattern)) {
            String msg = errorPrefix + " The value has unexpected whitespace characters.";
            throw new OperationParseException(msg);
        }
        try {
            declaringType = Type.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            String msg = errorPrefix + " The type given \"" + typeName + "\" was not recognized.";
            throw new OperationParseException(msg);
        }
        if (!declaringType.isEnum()) {
            String msg = errorPrefix + " The type given \"" + typeName + "\" is not an enum.";
            throw new OperationParseException(msg);
        }
        Enum<?> value = EnumConstant.valueOf(declaringType.getRuntimeClass(), valueName);
        if (value == null) {
            String msg = errorPrefix + " The value given \"" + valueName + "\" is not a constant of the enum " + typeName + ".";
            throw new OperationParseException(msg);
        }
        return new TypedClassOperation(new EnumConstant(value), (ClassOrInterfaceType)declaringType, new TypeTuple(), declaringType);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Enum<@SignatureUnknown @SignatureBottom ?> value() {
        return this.value;
    }

    @Override
    public @SignatureUnknown Object getValue() {
        return this.value();
    }

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Enum<@SignatureUnknown @SignatureBottom ?> valueOf(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> type, @SignatureUnknown String valueName) {
        for (Object obj : type.getEnumConstants()) {
            Enum e = (Enum)obj;
            if (!e.name().equals(valueName)) continue;
            return e;
        }
        return null;
    }
}

