/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.lang.reflect.Array;
import java.util.List;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.operation.CallableOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.sequence.Variable;
import randoop.types.Type;
import randoop.types.TypeTuple;

class ArrayElementSet
extends CallableOperation {
    private final @SignatureUnknown int ARRAY = 0;
    private final @SignatureUnknown int INDEX = 1;
    private final @SignatureUnknown int VALUE = 2;
    private final @SignatureUnknown Type elementType;

    ArrayElementSet(@SignatureUnknown Type elementType) {
        this.elementType = elementType;
    }

    @Override
    public @SignatureUnknown ExecutionOutcome execute(@SignatureUnknown Object @SignatureUnknown [] input) {
        assert (input.length == 3) : "array element assignment must have array, index and value as arguments";
        Object array = input[0];
        int index = (Integer)input[1];
        Object value = input[2];
        try {
            Array.set(array, index, value);
        }
        catch (Throwable thrown) {
            return new ExceptionalExecution(thrown, 0L);
        }
        return new NormalExecution(null, 0L);
    }

    @Override
    public void appendCode(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars, @SignatureUnknown StringBuilder b) {
        b.append(inputVars.get(0).getName()).append("[");
        Variable indexVariable = inputVars.get(1);
        String index = this.getArgumentString(indexVariable);
        b.append(index).append("]").append(" = ");
        String value = this.getArgumentString(inputVars.get(2));
        b.append(value);
    }

    @Override
    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType, @SignatureUnknown TypeTuple inputTypes, @SignatureUnknown Type outputType) {
        return this.getName();
    }

    @Override
    public @SignatureUnknown String getName() {
        return "<set>" + this.elementType + "[]";
    }
}

