/*
 * Decompiled with CFR 0.152.
 */
package randoop.main;

import java.util.ArrayList;
import java.util.List;
import randoop.Globals;
import randoop.condition.RandoopSpecificationError;
import randoop.generation.AbstractGenerator;
import randoop.main.CommandHandler;
import randoop.main.GenTests;
import randoop.main.Help;
import randoop.main.Minimize;
import randoop.main.RandoopBug;
import randoop.main.RandoopCommandError;
import randoop.main.RandoopUsageError;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.util.UtilPlume;
import randoop.sequence.Sequence;

public class Main {
    public static @SignatureUnknown List<@SignatureUnknown CommandHandler> handlers = new ArrayList<CommandHandler>();

    public static void main(@SignatureUnknown String @SignatureUnknown [] args) {
        Main main = new Main();
        main.nonStaticMain(args);
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nonStaticMain(@SignatureUnknown String @SignatureUnknown [] args) {
        if (args.length == 0) {
            args = new String[]{"help"};
        }
        String command = args[0];
        String[] args2 = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            args2[i - 1] = args[i];
        }
        CommandHandler handler = null;
        ArrayList<CommandHandler> allHandlers = new ArrayList<CommandHandler>();
        allHandlers.addAll(handlers);
        for (CommandHandler h2 : allHandlers) {
            if (!h2.handles(command)) continue;
            handler = h2;
            break;
        }
        if (handler == null) {
            System.out.println("Unrecognized command: " + command + ".");
            System.out.println("For more help, invoke Randoop with \"help\" as its sole argument.");
            System.exit(1);
        }
        boolean success = false;
        try {
            success = handler.handle(args2);
            if (!success) {
                System.err.println("The Randoop command " + handler.fcommand + " failed.");
            }
        }
        catch (RandoopUsageError e) {
            System.out.println();
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            if (e instanceof RandoopCommandError) {
                System.out.println("To get help on this command, invoke Randoop with arguments: help " + handler.fcommand);
            }
            System.exit(1);
        }
        catch (RandoopSpecificationError e) {
            System.out.println();
            if (e.getMessage() != null) {
                System.out.println(e.getMessage());
            }
            System.exit(1);
        }
        catch (RandoopBug e) {
            UtilPlume.sleep(1000L);
            System.out.println();
            System.out.println("Randoop failed in an unexpected way.");
            System.out.println("Please report at https://github.com/randoop/randoop/issues ,");
            System.out.println("providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .");
            e.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Throwable e) {
            System.out.println();
            System.out.println("Throwable thrown while handling command: " + e);
            e.printStackTrace(System.out);
            success = false;
        }
        finally {
            if (!success) {
                System.out.println();
                System.out.println("Randoop failed.");
                Sequence lastSequence = AbstractGenerator.currSeq;
                if (lastSequence == null) {
                    System.out.println("No sequences generated.");
                } else {
                    String[] lines;
                    System.out.println("Last sequence under execution: ");
                    for (String line : lines = lastSequence.toString().split(Globals.lineSep)) {
                        System.out.println(line);
                    }
                }
                System.exit(1);
            }
        }
    }

    static {
        handlers.add(new GenTests());
        handlers.add(new Help());
        handlers.add(new Minimize());
    }
}

