/*
 * Decompiled with CFR 0.152.
 */
package randoop.main;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import randoop.ExecutionVisitor;
import randoop.Globals;
import randoop.MethodReplacements;
import randoop.com.github.javaparser.ParseException;
import randoop.com.github.javaparser.ast.CompilationUnit;
import randoop.com.github.javaparser.ast.stmt.BlockStmt;
import randoop.condition.RandoopSpecificationError;
import randoop.condition.SpecificationCollection;
import randoop.execution.TestEnvironment;
import randoop.generation.AbstractGenerator;
import randoop.generation.ComponentManager;
import randoop.generation.ForwardGenerator;
import randoop.generation.RandoopGenerationError;
import randoop.generation.RandoopListenerManager;
import randoop.generation.SeedSequences;
import randoop.generation.TestUtils;
import randoop.instrument.CoveredClassVisitor;
import randoop.main.ClassNameErrorHandler;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.main.RandoopClassNameError;
import randoop.main.RandoopUsageError;
import randoop.main.ThrowClassNameError;
import randoop.main.WarnOnBadClassName;
import randoop.operation.OperationParseException;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.Identifier;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.options.Options;
import randoop.org.plumelib.util.EntryReader;
import randoop.org.plumelib.util.UtilPlume;
import randoop.output.CodeWriter;
import randoop.output.FailingAssertionCommentWriter;
import randoop.output.JUnitCreator;
import randoop.output.JavaFileWriter;
import randoop.output.MinimizerWriter;
import randoop.output.NameGenerator;
import randoop.output.RandoopOutputException;
import randoop.reflection.DefaultReflectionPredicate;
import randoop.reflection.OmitMethodsPredicate;
import randoop.reflection.OperationModel;
import randoop.reflection.RandoopInstantiationError;
import randoop.reflection.SignatureParseException;
import randoop.reflection.VisibilityPredicate;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Sequence;
import randoop.sequence.SequenceExceptionError;
import randoop.sequence.SequenceExecutionException;
import randoop.sequence.Statement;
import randoop.sequence.Variable;
import randoop.test.CompilableTestPredicate;
import randoop.test.ContractCheckingGenerator;
import randoop.test.ContractSet;
import randoop.test.ErrorTestPredicate;
import randoop.test.ExcludeTestPredicate;
import randoop.test.ExpectedExceptionCheckGen;
import randoop.test.ExtendGenerator;
import randoop.test.IncludeIfCoversPredicate;
import randoop.test.IncludeTestPredicate;
import randoop.test.RegressionCaptureGenerator;
import randoop.test.RegressionTestPredicate;
import randoop.test.TestCheckGenerator;
import randoop.test.ValidityCheckingGenerator;
import randoop.test.ValueSizePredicate;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.util.Log;
import randoop.util.MultiMap;
import randoop.util.Randomness;
import randoop.util.RandoopLoggingError;
import randoop.util.ReflectionExecutor;
import randoop.util.SimpleList;
import randoop.util.predicate.AlwaysFalse;

public class GenTests
extends GenInputsAbstract {
    private static final @SignatureUnknown String NO_OPERATIONS_TO_TEST = "There are no methods for Randoop to test.  See diagnostics above.  Exiting.";
    private static final @SignatureUnknown String command = "gentests";
    private static final @SignatureUnknown String pitch = "Generates unit tests for a set of classes.";
    private static final @SignatureUnknown String commandGrammar = "gentests OPTIONS";
    private static final @SignatureUnknown String where = "At least one of , `--testjar', `--classlist', `--testclass', or `--methodlist' is specified.";
    private static final @SignatureUnknown String summary = "Uses feedback-directed random test generation to generate error-revealing tests and regression tests. ";
    private static final @SignatureUnknown String input = "One or more names of classes to test. A class to test can be specified via the `--testjar', `--classlist', or `--testclass' options.";
    private static final @SignatureUnknown String output = "Two JUnit test suites (each as one or more Java source files): an error-revealing test suite and a regression test suite.";
    private static final @SignatureUnknown String example = "java randoop.main.Main gentests --testclass=java.util.Collections --testclass=java.util.TreeSet";
    private static final @SignatureUnknown List<@SignatureUnknown String> notes = new ArrayList<String>();
    public static final @Identifier String TEST_METHOD_NAME_PREFIX = "test";
    private @SignatureUnknown BlockStmt afterAllFixtureBody;
    private @SignatureUnknown BlockStmt afterEachFixtureBody;
    private @SignatureUnknown BlockStmt beforeAllFixtureBody;
    private @SignatureUnknown BlockStmt beforeEachFixtureBody;
    private static @SignatureUnknown Options options;
    private @SignatureUnknown int sequenceCompileFailureCount = 0;
    public static final @SignatureUnknown String POSSIBLY_FLAKY_PREFIX = "  Possibly flaky:  ";

    public GenTests() {
        super(command, pitch, commandGrammar, where, summary, notes, input, output, example, options);
    }

    @Override
    public @SignatureUnknown boolean handle(@SignatureUnknown String @SignatureUnknown [] args) {
        TypedClassOperation objectConstructor;
        VisibilityPredicate visibility;
        try {
            Object[] nonargs = options.parse(args);
            if (nonargs.length > 0) {
                throw new Options.ArgException("Unrecognized command-line arguments: " + Arrays.toString(nonargs));
            }
        }
        catch (Options.ArgException ae) {
            GenTests.usage("While parsing command-line arguments: %s", ae.getMessage());
        }
        if (GenInputsAbstract.progressdisplay) {
            System.out.println("Randoop for Java version " + Globals.getRandoopVersion() + ".");
        }
        this.checkOptionsValid();
        Randomness.setSeed(randomseed);
        for (String prop : GenInputsAbstract.system_props) {
            String[] pa = prop.split("=", 2);
            if (pa.length != 2) {
                GenTests.usage("invalid property definition: %s%n", prop);
            }
            System.setProperty(pa[0], pa[1]);
        }
        if (!this.getFixtureCode()) {
            System.exit(1);
        }
        if (GenInputsAbstract.junit_package_name == null) {
            visibility = VisibilityPredicate.IS_PUBLIC;
        } else if (GenInputsAbstract.only_test_public_members) {
            visibility = VisibilityPredicate.IS_PUBLIC;
            if (GenInputsAbstract.junit_package_name != null) {
                System.out.println("Not using package " + GenInputsAbstract.junit_package_name + " since --only-test-public-members is set");
            }
        } else {
            visibility = new VisibilityPredicate.PackageVisibilityPredicate(GenInputsAbstract.junit_package_name);
        }
        Set<@ClassGetName String> classnames = GenInputsAbstract.getClassnamesFromArgs(visibility);
        Set<@ClassGetName String> coveredClassnames = GenInputsAbstract.getClassNamesFromFile(require_covered_classes);
        Set<String> omitFields = GenInputsAbstract.getStringSetFromFile(omit_field_file, "fields");
        omitFields.addAll(omit_field);
        omitFields.addAll(GenInputsAbstract.getStringSetFromFile(omit_field_list, "fields"));
        for (Path omitMethodsFile : GenInputsAbstract.omit_methods_file) {
            omit_methods.addAll(this.readPatterns(omitMethodsFile));
        }
        for (Path omitMethodsFile : GenInputsAbstract.omitmethods_file) {
            omit_methods.addAll(this.readPatterns(omitMethodsFile));
        }
        for (Path omitClassesFile : GenInputsAbstract.omit_classes_file) {
            omit_classes.addAll(this.readPatterns(omitClassesFile));
        }
        if (!GenInputsAbstract.dont_omit_replaced_methods) {
            omit_methods.addAll(this.createPatternsFromSignatures(MethodReplacements.getSignatureList()));
        }
        if (!GenInputsAbstract.omit_methods_no_defaults) {
            omit_methods.addAll(this.readPatternsFromResource("/omitmethods-defaults.txt"));
            omit_methods.addAll(this.readPatternsFromResource("/JDK-nondet-methods.txt"));
        }
        if (!GenInputsAbstract.omit_classes_no_defaults) {
            String omitClassesDefaultsFileName = "/omit-classes-defaults.txt";
            InputStream inputStream = GenTests.class.getResourceAsStream(omitClassesDefaultsFileName);
            omit_classes.addAll(this.readPatterns(inputStream, omitClassesDefaultsFileName));
        }
        DefaultReflectionPredicate reflectionPredicate = new DefaultReflectionPredicate(omitFields);
        ClassNameErrorHandler classNameErrorHandler = new ThrowClassNameError();
        if (silently_ignore_bad_class_names) {
            classNameErrorHandler = new WarnOnBadClassName();
        }
        String classpath = Globals.getClassPath();
        if (GenInputsAbstract.use_jdk_specifications) {
            if (GenInputsAbstract.specifications == null) {
                GenInputsAbstract.specifications = new ArrayList<Path>();
            }
            GenInputsAbstract.specifications.addAll(this.getJDKSpecificationFiles());
        }
        SpecificationCollection operationSpecifications = null;
        try {
            operationSpecifications = SpecificationCollection.create(GenInputsAbstract.specifications);
        }
        catch (RandoopSpecificationError e) {
            System.out.println("Error in specifications: " + e.getMessage());
            System.exit(1);
        }
        OperationModel operationModel = null;
        try {
            operationModel = OperationModel.createModel(visibility, reflectionPredicate, omit_methods, classnames, coveredClassnames, classNameErrorHandler, GenInputsAbstract.literals_file, operationSpecifications);
        }
        catch (SignatureParseException e) {
            System.out.printf("%nError: parse exception thrown %s%n", e);
            System.out.println("Exiting Randoop.");
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            System.out.printf("%nError building operation model: %s%n", e);
            System.out.println("Exiting Randoop.");
            System.exit(1);
        }
        catch (RandoopClassNameError e) {
            System.out.printf("Class Name Error: %s%n", e.getMessage());
            if (e.getMessage().startsWith("No class with name \"")) {
                System.out.println("More specifically, none of the following files could be found:");
                StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String classFileName;
                    String classPathElt = tokenizer.nextToken();
                    if (classPathElt.endsWith(".jar")) {
                        classFileName = e.className.replace(".", "/") + ".class";
                        System.out.println("  " + classFileName + " in " + classPathElt);
                        continue;
                    }
                    classFileName = e.className.replace(".", File.separator) + ".class";
                    if (!classPathElt.endsWith(File.separator)) {
                        classPathElt = classPathElt + File.separator;
                    }
                    System.out.println("  " + classPathElt + classFileName);
                }
                System.out.println("Correct your classpath or the class name and re-run Randoop.");
            } else {
                System.out.println("Problem in OperationModel.createModel().");
                System.out.println("  visibility = " + visibility);
                System.out.println("  reflectionPredicate = " + reflectionPredicate);
                System.out.println("  omit_methods = " + omit_methods);
                System.out.println("  classnames = " + classnames);
                System.out.println("  coveredClassnames = " + coveredClassnames);
                System.out.println("  classNameErrorHandler = " + classNameErrorHandler);
                System.out.println("  GenInputsAbstract.literals_file = " + GenInputsAbstract.literals_file);
                System.out.println("  operationSpecifications = " + operationSpecifications);
                e.printStackTrace(System.out);
            }
            System.exit(1);
        }
        catch (RandoopSpecificationError e) {
            System.out.printf("Specification Error: %s%n", e.getMessage());
            System.exit(1);
        }
        assert (operationModel != null);
        List<TypedOperation> operations = operationModel.getOperations();
        Set<ClassOrInterfaceType> classesUnderTest = operationModel.getClassTypes();
        if (operations.size() <= 1) {
            System.out.println("You provided no methods to test, so no tests for them can be generated.");
            System.out.println();
            System.out.println("Additional diagnostis appear below.");
            operationModel.dumpModel(System.out);
            System.out.println();
            System.out.println(NO_OPERATIONS_TO_TEST);
            System.exit(1);
        }
        if (GenInputsAbstract.progressdisplay) {
            System.out.println("PUBLIC MEMBERS=" + operations.size());
        }
        LinkedHashSet<Sequence> components = new LinkedHashSet<Sequence>();
        components.addAll(SeedSequences.defaultSeeds());
        components.addAll(operationModel.getAnnotatedTestValues());
        ComponentManager componentMgr = new ComponentManager(components);
        operationModel.addClassLiterals(componentMgr, GenInputsAbstract.literals_file, GenInputsAbstract.literals_level);
        RandoopListenerManager listenerMgr = new RandoopListenerManager();
        MultiMap<Type, TypedClassOperation> sideEffectFreeMethodsByType = GenTests.readSideEffectFreeMethods();
        LinkedHashSet<TypedOperation> sideEffectFreeMethods = new LinkedHashSet<TypedOperation>();
        for (Type keyType : sideEffectFreeMethodsByType.keySet()) {
            sideEffectFreeMethods.addAll(sideEffectFreeMethodsByType.getValues(keyType));
        }
        ForwardGenerator explorer = new ForwardGenerator(operations, sideEffectFreeMethods, new GenInputsAbstract.Limits(), componentMgr, listenerMgr, classesUnderTest);
        operationModel.log();
        if (GenInputsAbstract.operation_history_log != null) {
            TestUtils.setOperationLog(new PrintWriter(GenInputsAbstract.operation_history_log), (AbstractGenerator)explorer);
        }
        TestUtils.setSelectionLog(GenInputsAbstract.selection_log);
        ContractSet contracts = operationModel.getContracts();
        TestCheckGenerator testGen = GenTests.createTestCheckGenerator(visibility, contracts, sideEffectFreeMethodsByType, operationModel.getOmitMethodsPredicate());
        explorer.setTestCheckGenerator(testGen);
        try {
            objectConstructor = TypedOperation.forConstructor(Object.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("failed to get Object constructor", e);
        }
        Sequence newObj = new Sequence().extend((TypedOperation)objectConstructor, new Variable[0]);
        LinkedHashSet<Sequence> excludeSet = new LinkedHashSet<Sequence>();
        excludeSet.add(newObj);
        Predicate<ExecutableSequence> isOutputTest = this.createTestOutputPredicate(excludeSet, operationModel.getCoveredClassesGoal(), GenInputsAbstract.require_classname_in_test);
        explorer.setTestPredicate(isOutputTest);
        ArrayList<ExecutionVisitor> visitors = new ArrayList<ExecutionVisitor>();
        if (GenInputsAbstract.require_covered_classes != null) {
            visitors.add((ExecutionVisitor)new CoveredClassVisitor(operationModel.getCoveredClassesGoal()));
        }
        if (!GenInputsAbstract.visitor.isEmpty()) {
            for (String visitorClsName : GenInputsAbstract.visitor) {
                try {
                    Class<?> cls = Class.forName(visitorClsName);
                    ExecutionVisitor vis = (ExecutionVisitor)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    visitors.add(vis);
                }
                catch (Exception e) {
                    throw new RandoopBug("Error while loading visitor class " + visitorClsName, e);
                }
            }
        }
        explorer.setExecutionVisitor(visitors);
        if (GenInputsAbstract.progressdisplay) {
            System.out.printf("Explorer = %s%n", explorer);
        }
        if (Log.isLoggingOn()) {
            Log.logPrintf("Initial sequences (seeds):%n", new Object[0]);
            componentMgr.log();
        }
        try {
            explorer.createAndClassifySequences();
        }
        catch (SequenceExceptionError e) {
            this.printSequenceExceptionError(explorer, e);
            System.exit(1);
        }
        catch (RandoopInstantiationError e) {
            throw new RandoopBug("Error instantiating operation " + e.getOpName(), e);
        }
        catch (RandoopGenerationError e) {
            throw new RandoopBug("Error in generation with operation " + e.getInstantiatedOperation(), e);
        }
        catch (SequenceExecutionException e) {
            throw new RandoopBug("Error executing generated sequence", e);
        }
        catch (RandoopLoggingError e) {
            throw new RandoopBug("Logging error", e);
        }
        catch (Throwable e) {
            System.out.printf("createAndClassifySequences threw an exception%n%s%n", UtilPlume.stackTraceToString(e));
            throw e;
        }
        if (GenInputsAbstract.dont_output_tests) {
            return true;
        }
        JUnitCreator junitCreator = JUnitCreator.getTestCreator(junit_package_name, this.beforeAllFixtureBody, this.afterAllFixtureBody, this.beforeEachFixtureBody, this.afterEachFixtureBody);
        JavaFileWriter javaFileWriter = new JavaFileWriter(junit_output_dir);
        if (!GenInputsAbstract.no_error_revealing_tests) {
            CodeWriter codeWriter = javaFileWriter;
            if (GenInputsAbstract.minimize_error_test || GenInputsAbstract.stop_on_error_test) {
                codeWriter = new MinimizerWriter(javaFileWriter);
            }
            this.writeTestFiles(junitCreator, explorer.getErrorTestSequences(), codeWriter, GenInputsAbstract.error_test_basename, "Error-revealing");
        }
        if (!GenInputsAbstract.no_regression_tests) {
            TestEnvironment testEnvironment = new TestEnvironment(this.convertClasspathToAbsolute(classpath));
            String agentPathString = MethodReplacements.getAgentPath();
            String agentArgs = MethodReplacements.getAgentArgs();
            if (agentPathString != null && !agentPathString.isEmpty()) {
                Path agentPath = Paths.get(agentPathString, new String[0]);
                testEnvironment.setReplaceCallAgent(agentPath, agentArgs);
            }
            List<ExecutableSequence> regressionSequences = explorer.getRegressionSequences();
            if (GenInputsAbstract.progressdisplay) {
                System.out.printf("%nAbout to look for failing assertions in %d regression sequences.%n", regressionSequences.size());
            }
            FailingAssertionCommentWriter codeWriter = new FailingAssertionCommentWriter(testEnvironment, javaFileWriter);
            this.writeTestFiles(junitCreator, regressionSequences, codeWriter, GenInputsAbstract.regression_test_basename, "Regression");
            if (GenInputsAbstract.progressdisplay) {
                System.out.printf("About to look for flaky methods.%n", new Object[0]);
            }
            this.processAndOutputFlakyMethods(this.testNamesToSequences(codeWriter.getFlakyTestNames(), regressionSequences), regressionSequences, sideEffectFreeMethodsByType, operationModel.getOmitMethodsPredicate(), visibility);
        }
        if (GenInputsAbstract.progressdisplay) {
            System.out.printf("%nInvalid tests generated: %d%n", explorer.invalidSequenceCount);
        }
        if (this.sequenceCompileFailureCount > 0) {
            System.out.printf("%nUncompilable sequences generated (count: %d).%n", this.sequenceCompileFailureCount);
            System.out.println("Please report uncompilable sequences at https://github.com/randoop/randoop/issues ,");
            System.out.println("providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .");
        }
        explorer.getOperationHistory().outputTable();
        return true;
    }

    public static @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> readSideEffectFreeMethods() {
        MultiMap<Type, TypedClassOperation> sideEffectFreeUserMethods;
        String sefDefaultsFileName = "/JDK-sef-methods.txt";
        InputStream inputStream = GenTests.class.getResourceAsStream(sefDefaultsFileName);
        MultiMap<Type, TypedClassOperation> sideEffectFreeJDKMethods = OperationModel.readOperations(inputStream, sefDefaultsFileName, true);
        try {
            sideEffectFreeUserMethods = OperationModel.readOperations(GenInputsAbstract.side_effect_free_methods);
        }
        catch (OperationParseException e) {
            throw new RandoopUsageError(String.format("Incorrectly formatted method in file %s: %s%n", GenInputsAbstract.side_effect_free_methods, e));
        }
        MultiMap<Type, TypedClassOperation> result = new MultiMap<Type, TypedClassOperation>();
        result.addAll(sideEffectFreeJDKMethods);
        result.addAll(sideEffectFreeUserMethods);
        return result;
    }

    private void processAndOutputFlakyMethods(@SignatureUnknown List<@SignatureUnknown ExecutableSequence> flakySequences, @SignatureUnknown List<@SignatureUnknown ExecutableSequence> sequences, @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> sideEffectFreeMethodsByType, @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @SignatureUnknown VisibilityPredicate visibilityPredicate) {
        if (flakySequences.isEmpty()) {
            return;
        }
        MultiMap<Type, TypedClassOperation> assertableSideEffectFreeMethods = new MultiMap<Type, TypedClassOperation>();
        for (Type t : sideEffectFreeMethodsByType.keySet()) {
            Set<TypedClassOperation> typeOperations = sideEffectFreeMethodsByType.getValues(t);
            for (TypedClassOperation tco : typeOperations) {
                if (!RegressionCaptureGenerator.isAssertableMethod(tco, omitMethodsPredicate, visibilityPredicate)) continue;
                assertableSideEffectFreeMethods.add(t, tco);
            }
        }
        System.out.println();
        System.out.println("Flaky tests were generated. This means that your program contains");
        System.out.println("methods that are nondeterministic or depend on non-local state.");
        if (GenInputsAbstract.nondeterministic_methods_to_output > 0) {
            Map<TypedClassOperation, Integer> testOccurrences = this.countSequencesPerOperation(sequences, assertableSideEffectFreeMethods);
            Map<TypedClassOperation, Integer> flakyOccurrences = this.countSequencesPerOperation(flakySequences, assertableSideEffectFreeMethods);
            PriorityQueue<TypedOperation.RankedTypeOperation> methodHeuristicPriorityQueue = new PriorityQueue<TypedOperation.RankedTypeOperation>(TypedOperation.compareRankedTypeOperation.reversed());
            for (TypedClassOperation op : flakyOccurrences.keySet()) {
                double tfIdfMetric = flakyOccurrences.get(op) / testOccurrences.get(op);
                TypedOperation.RankedTypeOperation rankedMethod = new TypedOperation.RankedTypeOperation(tfIdfMetric, op);
                methodHeuristicPriorityQueue.add(rankedMethod);
            }
            System.out.println("The following methods, in decreasing order of likelihood,");
            System.out.println("are the most likely to be the problem.");
            int maxMethodsToOutput = GenInputsAbstract.nondeterministic_methods_to_output;
            for (int i = 0; i < maxMethodsToOutput && !methodHeuristicPriorityQueue.isEmpty(); ++i) {
                TypedOperation.RankedTypeOperation rankedMethod = (TypedOperation.RankedTypeOperation)methodHeuristicPriorityQueue.remove();
                System.out.println(POSSIBLY_FLAKY_PREFIX + rankedMethod.operation.getFullyQualifiedSignature());
            }
        }
        System.out.println("To prevent the generation of flaky tests, see section 'Randoop generated flaky tests'");
        System.out.println(" at https://randoop.github.io/randoop/manual/#flaky-tests .");
        System.out.println();
    }

    private @SignatureUnknown List<@SignatureUnknown ExecutableSequence> testNamesToSequences(@SignatureUnknown Iterable<@SignatureUnknown String> testNames, @SignatureUnknown List<@SignatureUnknown ExecutableSequence> sequences) {
        ArrayList<ExecutableSequence> result = new ArrayList<ExecutableSequence>();
        for (String testName : testNames) {
            int testNum = Integer.parseInt(testName.substring(TEST_METHOD_NAME_PREFIX.length()));
            ExecutableSequence eseq = sequences.get(testNum - 1);
            result.add(eseq);
        }
        return result;
    }

    private @SignatureUnknown Map<@SignatureUnknown TypedClassOperation, @SignatureUnknown Integer> countSequencesPerOperation(@SignatureUnknown List<@SignatureUnknown ExecutableSequence> sequences, @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> assertableSideEffectFreeMethods) {
        HashMap<TypedClassOperation, Integer> numSequencesUsedIn = new HashMap<TypedClassOperation, Integer>();
        for (ExecutableSequence es : sequences) {
            Set<TypedClassOperation> ops = this.getOperationsInSequence(es);
            for (TypedClassOperation to : ops) {
                numSequencesUsedIn.merge(to, 1, Integer::sum);
            }
            SimpleList<Statement> statements = es.sequence.statements;
            Statement lastStatement = statements.get(statements.size() - 1);
            Type lastValueType = lastStatement.getOutputType();
            for (TypedClassOperation tco : assertableSideEffectFreeMethods.getValues(lastValueType)) {
                numSequencesUsedIn.merge(tco, 1, Integer::sum);
            }
        }
        return numSequencesUsedIn;
    }

    private @SignatureUnknown Set<@SignatureUnknown TypedClassOperation> getOperationsInSequence(@SignatureUnknown ExecutableSequence es) {
        HashSet<TypedClassOperation> ops = new HashSet<TypedClassOperation>();
        SimpleList<Statement> statements = es.sequence.statements;
        for (int i = 0; i < statements.size(); ++i) {
            TypedOperation to = statements.get(i).getOperation();
            if (!to.isMethodCall()) continue;
            ops.add((TypedClassOperation)to);
        }
        return ops;
    }

    private @SignatureUnknown String convertClasspathToAbsolute(@SignatureUnknown String classpath) {
        String[] relpaths = classpath.split(File.pathSeparator);
        int length = relpaths.length;
        String[] abspaths = new String[length];
        for (int i = 0; i < length; ++i) {
            String rel = relpaths[i];
            String abs = rel.equals("") ? rel : Paths.get(rel, new String[0]).toAbsolutePath().toString();
            abspaths[i] = abs;
        }
        return UtilPlume.join((CharSequence)File.pathSeparator, abspaths);
    }

    private void writeTestFiles(@SignatureUnknown JUnitCreator junitCreator, @SignatureUnknown List<@SignatureUnknown ExecutableSequence> testSequences, @SignatureUnknown CodeWriter codeWriter, @SignatureUnknown String classNamePrefix, @SignatureUnknown String testKind) {
        if (testSequences.isEmpty()) {
            if (GenInputsAbstract.progressdisplay) {
                System.out.printf("%nNo " + testKind.toLowerCase() + " tests to output.%n", new Object[0]);
            }
            return;
        }
        if (GenInputsAbstract.progressdisplay) {
            System.out.printf("%n%s test output:%n", testKind);
            System.out.printf("%s test count: %d%n", testKind, testSequences.size());
            System.out.printf("Writing %s JUnit tests...%n", testKind.toLowerCase());
        }
        try {
            String classSource;
            String driverName;
            ArrayList<String> testClasses = new ArrayList<String>();
            int numTests = testSequences.size();
            int numFiles = (numTests - 1) / testsperfile + 1;
            NameGenerator methodNameGenerator = new NameGenerator(TEST_METHOD_NAME_PREFIX, 1, numTests);
            for (int i = 0; i < numFiles; ++i) {
                List<ExecutableSequence> partition = testSequences.subList(i * testsperfile, Math.min((i + 1) * testsperfile, numTests));
                String testClassName = classNamePrefix + i;
                testClasses.add(testClassName);
                CompilationUnit classAST = junitCreator.createTestClass(testClassName, methodNameGenerator, partition);
                String classSource2 = classAST.toString();
                Path testFile = codeWriter.writeClassCode(GenInputsAbstract.junit_package_name, testClassName, classSource2);
                if (!GenInputsAbstract.progressdisplay) continue;
                System.out.printf("Created file %s%n", testFile.toAbsolutePath());
            }
            if (GenInputsAbstract.junit_reflection_allowed) {
                driverName = classNamePrefix;
                classSource = junitCreator.createTestSuite(driverName, testClasses);
            } else {
                driverName = classNamePrefix + "Driver";
                classSource = junitCreator.createTestDriver(driverName, testClasses, numTests);
            }
            Path suiteFile = codeWriter.writeUnmodifiedClassCode(GenInputsAbstract.junit_package_name, driverName, classSource);
            if (GenInputsAbstract.progressdisplay) {
                System.out.printf("Created file %s%n", suiteFile.toAbsolutePath());
            }
        }
        catch (RandoopOutputException e) {
            System.out.printf("%nError writing %s tests%n", testKind.toLowerCase());
            e.printStackTrace(System.out);
            System.exit(1);
        }
        catch (Throwable e) {
            System.out.printf("GenTests.writeTestFiles threw an exception%n", new Object[0]);
            e.printStackTrace(System.out);
            throw e;
        }
        if (GenInputsAbstract.progressdisplay) {
            System.out.printf("Wrote %s JUnit tests.%n", testKind.toLowerCase());
        }
    }

    private @SignatureUnknown boolean getFixtureCode() {
        boolean badFixtureText = false;
        try {
            this.afterAllFixtureBody = JUnitCreator.parseFixture(GenTests.getFileText(GenInputsAbstract.junit_after_all));
        }
        catch (ParseException e) {
            System.out.println("Error in after-all fixture text at token " + e.currentToken);
            badFixtureText = true;
        }
        try {
            this.afterEachFixtureBody = JUnitCreator.parseFixture(GenTests.getFileText(GenInputsAbstract.junit_after_each));
        }
        catch (ParseException e) {
            System.out.println("Error in after-each fixture text at token " + e.currentToken);
            badFixtureText = true;
        }
        try {
            this.beforeAllFixtureBody = JUnitCreator.parseFixture(GenTests.getFileText(GenInputsAbstract.junit_before_all));
        }
        catch (ParseException e) {
            System.out.println("Error in before-all fixture text at token " + e.currentToken);
            badFixtureText = true;
        }
        try {
            this.beforeEachFixtureBody = JUnitCreator.parseFixture(GenTests.getFileText(GenInputsAbstract.junit_before_each));
        }
        catch (ParseException e) {
            System.out.println("Error in before-each fixture text at token " + e.currentToken);
            badFixtureText = true;
        }
        return !badFixtureText;
    }

    private @SignatureUnknown List<@SignatureUnknown Pattern> readPatterns(@SignatureUnknown Path file) {
        if (file != null) {
            List<Pattern> list;
            EntryReader er = new EntryReader(file.toFile(), "^#.*", null);
            try {
                list = this.readPatterns(er);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        er.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RandoopUsageError("Error reading file " + file + ":", e);
                }
            }
            er.close();
            return list;
        }
        return new ArrayList<Pattern>();
    }

    private @SignatureUnknown List<@SignatureUnknown Pattern> readPatternsFromResource(@SignatureUnknown String filename) {
        InputStream inputStream = GenTests.class.getResourceAsStream(filename);
        return this.readPatterns(inputStream, filename);
    }

    private @SignatureUnknown List<@SignatureUnknown Pattern> readPatterns(@SignatureUnknown InputStream is, @SignatureUnknown String filename) {
        List<Pattern> list;
        EntryReader er = new EntryReader(is, filename, "^#.*", null);
        try {
            list = this.readPatterns(er);
        }
        catch (Throwable throwable) {
            try {
                try {
                    er.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RandoopBug("Error reading from " + filename, e);
            }
        }
        er.close();
        return list;
    }

    private @SignatureUnknown List<@SignatureUnknown Pattern> readPatterns(@SignatureUnknown EntryReader er) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        for (String line : er) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) continue;
            try {
                Pattern pattern = Pattern.compile(trimmed);
                result.add(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new RandoopUsageError("Bad regex " + trimmed + " while reading file " + er.getFileName(), e);
            }
        }
        return result;
    }

    private @SignatureUnknown List<@SignatureUnknown Pattern> createPatternsFromSignatures(@SignatureUnknown List<@SignatureUnknown String> signatures) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String signatureString : signatures) {
            patterns.add(this.signatureToPattern(signatureString));
        }
        return patterns;
    }

    private @SignatureUnknown Pattern signatureToPattern(@SignatureUnknown String signatureString) {
        String patternString = signatureString.replaceAll(" ", "").replaceAll("\\.", "\\\\.").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\$", "\\\\$").replaceAll("\\[", "\\\\[").replaceAll("\\]", "\\\\]");
        return Pattern.compile(patternString);
    }

    private void printSequenceExceptionError(@SignatureUnknown AbstractGenerator explorer, @SignatureUnknown SequenceExceptionError e) {
        StringJoiner msg = new StringJoiner(Globals.lineSep);
        msg.add("");
        msg.add("");
        msg.add("ERROR: Randoop stopped because of a flaky test.");
        msg.add("");
        msg.add("This can happen when Randoop is run on methods that side-effect global state.");
        msg.add("It can also indicate a bug in Randoop.  For example, it is often a bug in");
        msg.add("Randoop if the Exception is ClassCastException and the Input Subsequence\"");
        msg.add("below compiles but does not run.");
        msg.add("See the below info and https://randoop.github.io/randoop/manual/#flaky-tests .");
        msg.add("");
        msg.add(String.format("Exception:%n  %s%n", e.getError()));
        msg.add(String.format("Statement:%n  %s%n", e.getStatement()));
        msg.add(String.format("Full sequence:%n%s", e.getSequence()));
        msg.add(String.format("Input subsequence:%n%s", e.getSubsequence().toCodeString()));
        Log.logPrintf("%s%n", msg);
        System.out.println(msg);
        if (GenInputsAbstract.log == null) {
            System.out.println("For more details, rerun with logging turned on with --log=FILENAME.");
        } else {
            System.out.println("For more details, see the log at " + GenInputsAbstract.log);
        }
        if (Log.isLoggingOn()) {
            Sequence subsequence = e.getSubsequence();
            ArrayList<String> executedOperationTrace = new ArrayList<String>();
            boolean flakySequenceFound = false;
            for (Sequence sequence : explorer.getAllSequences()) {
                if (subsequence.equals(sequence)) {
                    flakySequenceFound = true;
                }
                if (!flakySequenceFound) continue;
                for (int i = 0; i < sequence.statements.size(); ++i) {
                    TypedOperation operation = sequence.statements.get(i).getOperation();
                    if (operation.isNonreceivingValue()) continue;
                    executedOperationTrace.add(((Object)operation).toString());
                }
            }
            if (!executedOperationTrace.isEmpty()) {
                Log.logPrintf("Operations performed since subsequence first executed:%n", new Object[0]);
                for (String opName : executedOperationTrace) {
                    Log.logPrintf("%s%n", opName);
                }
            } else {
                Log.logPrintf("No previous occurrence of subsequence where exception was thrown:%n%s%n", subsequence);
            }
            Log.logPrintf("%n", new Object[0]);
            Log.logStackTrace(e);
        }
    }

    public @SignatureUnknown Predicate<@SignatureUnknown ExecutableSequence> createTestOutputPredicate(@SignatureUnknown Set<@SignatureUnknown Sequence> excludeSet, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Set<@SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?>> coveredClasses, @SignatureUnknown Pattern includePattern) {
        if (GenInputsAbstract.dont_output_tests) {
            return new AlwaysFalse<ExecutableSequence>();
        }
        Predicate<ExecutableSequence> baseTest = new ExcludeTestPredicate(excludeSet);
        if (includePattern != null) {
            baseTest = baseTest.and(new IncludeTestPredicate(includePattern));
        }
        if (!coveredClasses.isEmpty()) {
            baseTest = baseTest.and(new IncludeIfCoversPredicate(coveredClasses));
        }
        baseTest = baseTest.and(new ValueSizePredicate());
        Predicate<Object> checkTest = GenInputsAbstract.no_regression_tests && GenInputsAbstract.no_error_revealing_tests ? new AlwaysFalse() : (GenInputsAbstract.no_regression_tests ? new ErrorTestPredicate() : (GenInputsAbstract.no_error_revealing_tests ? new RegressionTestPredicate() : new ErrorTestPredicate().or(new RegressionTestPredicate())));
        Predicate<ExecutableSequence> isOutputTest = baseTest.and(checkTest);
        if (GenInputsAbstract.check_compilable) {
            JUnitCreator junitCreator = JUnitCreator.getTestCreator(junit_package_name, this.beforeAllFixtureBody, this.afterAllFixtureBody, this.beforeEachFixtureBody, this.afterEachFixtureBody);
            isOutputTest = isOutputTest.and(new CompilableTestPredicate(junitCreator, this));
        }
        return isOutputTest;
    }

    public static @SignatureUnknown TestCheckGenerator createTestCheckGenerator(@SignatureUnknown VisibilityPredicate visibility, @SignatureUnknown ContractSet contracts, @SignatureUnknown MultiMap<@SignatureUnknown Type, @SignatureUnknown TypedClassOperation> sideEffectFreeMethodsByType, @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate) {
        TestCheckGenerator testGen = new ValidityCheckingGenerator(GenInputsAbstract.flaky_test_behavior == GenInputsAbstract.FlakyTestAction.HALT);
        ContractCheckingGenerator contractVisitor = new ContractCheckingGenerator(contracts);
        testGen = new ExtendGenerator(testGen, contractVisitor);
        if (!GenInputsAbstract.no_regression_tests) {
            ExpectedExceptionCheckGen expectation = new ExpectedExceptionCheckGen(visibility);
            RegressionCaptureGenerator regressionVisitor = new RegressionCaptureGenerator(expectation, sideEffectFreeMethodsByType, visibility, omitMethodsPredicate, !GenInputsAbstract.no_regression_assertions);
            testGen = new ExtendGenerator(testGen, regressionVisitor);
        }
        return testGen;
    }

    private static void usage(@SignatureUnknown String format, Object ... args) {
        System.out.print("ERROR: ");
        System.out.printf(format, args);
        System.out.println();
        System.out.println(options.usage(new String[0]));
        System.exit(-1);
    }

    private static @SignatureUnknown List<@SignatureUnknown String> getFileText(@SignatureUnknown String filename) {
        if (filename == null) {
            return null;
        }
        try {
            return UtilPlume.fileLines(filename);
        }
        catch (IOException e) {
            System.err.println("Unable to read " + filename);
            System.exit(1);
            throw new Error("This can't happen.");
        }
    }

    private @SignatureUnknown Collection<@SignatureBottom ? extends @SignatureUnknown Path> getJDKSpecificationFiles() {
        ArrayList<Path> fileList = new ArrayList<Path>();
        String specificationDirectory = "/specifications/jdk/";
        Path directoryPath = this.getResourceDirectoryPath("/specifications/jdk/");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directoryPath, "json");){
            for (Path entry : stream) {
                fileList.add(entry);
            }
        }
        catch (IOException e) {
            throw new RandoopBug("Error reading JDK specification directory", e);
        }
        return fileList;
    }

    private @SignatureUnknown Path getResourceDirectoryPath(@SignatureUnknown String resourceDirectory) {
        URI directoryURI;
        try {
            directoryURI = GenTests.class.getResource(resourceDirectory).toURI();
        }
        catch (URISyntaxException e) {
            throw new RandoopBug("Error locating directory " + resourceDirectory, e);
        }
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystems.newFileSystem(directoryURI, Collections.emptyMap());
        }
        catch (IOException e) {
            throw new RandoopBug("Error locating directory " + resourceDirectory, e);
        }
        return fileSystem.getPath(resourceDirectory, new String[0]);
    }

    public void incrementSequenceCompileFailureCount() {
        ++this.sequenceCompileFailureCount;
    }

    static {
        notes.add("See the Randoop manual for guidance.  Here are a few important tips.");
        notes.add("Randoop executes the code under test, with no mechanisms to protect your system from harm resulting from arbitrary code execution. If random execution of your code could have undesirable effects (e.g., deletion of files, opening network connections, etc.) make sure you execute Randoop in a sandbox.");
        notes.add("Randoop will only use methods from the classes that you specify for testing. If Randoop is not generating tests for a particular method, make sure that you include classes for the types that the method requires. ");
        notes.add("Randoop may be deterministic when the code under test is itself deterministic. This means that two runs of Randoop may generate the same tests. To get variation across runs, use the --randomseed option.");
        options = new Options(GenTests.class, GenInputsAbstract.class, ReflectionExecutor.class, ForwardGenerator.class, AbstractGenerator.class);
    }
}

