/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.util.HashMap;
import java.util.Map;
import randoop.generation.InputSequenceSelector;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.sequence.Sequence;
import randoop.util.Randomness;
import randoop.util.SimpleList;

public class SmallTestsSequenceSelection
implements InputSequenceSelector {
    private final @SignatureUnknown Map<@SignatureUnknown Sequence, @SignatureUnknown Double> weightMap = new HashMap<Sequence, Double>();

    @Override
    public @SignatureUnknown Sequence selectInputSequence(@SignatureUnknown SimpleList<@SignatureUnknown Sequence> candidates) {
        double totalWeight = this.updateWeightMapForCandidates(candidates);
        return Randomness.randomMemberWeighted(candidates, this.weightMap, totalWeight);
    }

    private @SignatureUnknown double updateWeightMapForCandidates(@SignatureUnknown SimpleList<@SignatureUnknown Sequence> candidates) {
        double totalWeight = 0.0;
        for (int i = 0; i < candidates.size(); ++i) {
            Sequence candidate = candidates.get(i);
            Double weight = this.weightMap.get(candidate);
            if (weight == null) {
                weight = 1.0 / (double)candidate.size();
            }
            totalWeight += weight.doubleValue();
            this.weightMap.put(candidate, weight);
        }
        return totalWeight;
    }
}

