/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import randoop.generation.OperationHistoryLogInterface;
import randoop.generation.OperationOutcome;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;

public class OperationHistoryLogger
implements OperationHistoryLogInterface {
    private final @SignatureUnknown PrintWriter writer;
    private final @SignatureUnknown Map<@SignatureUnknown TypedOperation, @SignatureUnknown Map<@SignatureUnknown OperationOutcome, @SignatureUnknown Integer>> operationMap;

    public OperationHistoryLogger(@SignatureUnknown PrintWriter writer) {
        this.writer = writer;
        this.operationMap = new HashMap<TypedOperation, Map<OperationOutcome, Integer>>();
    }

    @Override
    public void add(@SignatureUnknown TypedOperation operation, @SignatureUnknown OperationOutcome outcome) {
        Map<OperationOutcome, Integer> outcomeMap = this.operationMap.get(operation);
        int count = 0;
        if (outcomeMap == null) {
            outcomeMap = new EnumMap<OperationOutcome, Integer>(OperationOutcome.class);
        } else {
            Integer countInteger = outcomeMap.get((Object)outcome);
            if (countInteger != null) {
                count = countInteger;
            }
        }
        outcomeMap.put(outcome, ++count);
        this.operationMap.put(operation, outcomeMap);
    }

    @Override
    public void outputTable() {
        this.writer.format("%nOperation History:%n", new Object[0]);
        int maxNameLength = 0;
        for (TypedOperation operation : this.operationMap.keySet()) {
            int nameLength = operation.getSignatureString().length();
            maxNameLength = Math.max(nameLength, maxNameLength);
        }
        Map<OperationOutcome, String> formatMap = this.printHeader(maxNameLength);
        ArrayList<TypedOperation> keys = new ArrayList<TypedOperation>(this.operationMap.keySet());
        Collections.sort(keys);
        for (TypedOperation key : keys) {
            this.printRow(maxNameLength, formatMap, key, this.operationMap.get(key));
        }
        this.writer.flush();
    }

    private @SignatureUnknown Map<@SignatureUnknown OperationOutcome, @SignatureUnknown String> printHeader(@SignatureUnknown int firstColumnLength) {
        EnumMap<OperationOutcome, String> formatMap = new EnumMap<OperationOutcome, String>(OperationOutcome.class);
        this.writer.format("%-" + firstColumnLength + "s", "Operation");
        for (OperationOutcome outcome : OperationOutcome.values()) {
            this.writer.format("\t%" + outcome.name().length() + "s", new Object[]{outcome});
            formatMap.put(outcome, "\t%" + outcome.name().length() + "d");
        }
        this.writer.format("%n", new Object[0]);
        return formatMap;
    }

    private void printRow(@SignatureUnknown int firstColumnLength, @SignatureUnknown Map<@SignatureUnknown OperationOutcome, @SignatureUnknown String> formatMap, @SignatureUnknown TypedOperation operation, @SignatureUnknown Map<@SignatureUnknown OperationOutcome, @SignatureUnknown Integer> countMap) {
        this.writer.format("%-" + firstColumnLength + "s", operation.getSignatureString());
        for (OperationOutcome outcome : OperationOutcome.values()) {
            Integer count = countMap.get((Object)outcome);
            if (count == null) {
                count = 0;
            }
            this.writer.format(formatMap.get((Object)outcome), count);
        }
        this.writer.format("%n", new Object[0]);
    }
}

