/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import randoop.main.RandoopBug;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.reflection.TypeInstantiator;
import randoop.sequence.ClassLiterals;
import randoop.sequence.PackageLiterals;
import randoop.sequence.Sequence;
import randoop.sequence.SequenceCollection;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.PrimitiveType;
import randoop.types.Type;
import randoop.util.ListOfLists;
import randoop.util.Log;
import randoop.util.SimpleList;

public class ComponentManager {
    private @SignatureUnknown SequenceCollection gralComponents;
    private final @SignatureUnknown Collection<@SignatureUnknown Sequence> gralSeeds;
    private @SignatureUnknown ClassLiterals classLiterals = null;
    private @SignatureUnknown PackageLiterals packageLiterals = null;

    public ComponentManager() {
        this.gralComponents = new SequenceCollection();
        this.gralSeeds = Collections.unmodifiableSet(Collections.emptySet());
    }

    public ComponentManager(@SignatureUnknown Collection<@SignatureUnknown Sequence> generalSeeds) {
        LinkedHashSet<Sequence> seedSet = new LinkedHashSet<Sequence>(generalSeeds.size());
        seedSet.addAll(generalSeeds);
        this.gralSeeds = Collections.unmodifiableSet(seedSet);
        this.gralComponents = new SequenceCollection(seedSet);
    }

    public @SignatureUnknown int numGeneratedSequences() {
        return this.gralComponents.size();
    }

    public void addClassLevelLiteral(@SignatureUnknown ClassOrInterfaceType type, @SignatureUnknown Sequence seq) {
        if (this.classLiterals == null) {
            this.classLiterals = new ClassLiterals();
        }
        this.classLiterals.addSequence(type, seq);
    }

    public void addPackageLevelLiteral(@SignatureUnknown Package pkg, @SignatureUnknown Sequence seq) {
        if (this.packageLiterals == null) {
            this.packageLiterals = new PackageLiterals();
        }
        this.packageLiterals.addSequence(pkg, seq);
    }

    public void addGeneratedSequence(@SignatureUnknown Sequence sequence) {
        this.gralComponents.add(sequence);
    }

    void clearGeneratedSequences() {
        this.gralComponents = new SequenceCollection(this.gralSeeds);
    }

    @SignatureUnknown Set<@SignatureUnknown Sequence> getAllGeneratedSequences() {
        return this.gralComponents.getAllSequences();
    }

    @SignatureUnknown SimpleList<@SignatureUnknown Sequence> getSequencesForType(@SignatureUnknown Type cls) {
        return this.gralComponents.getSequencesForType(cls, false, false);
    }

    @SignatureUnknown SimpleList<@SignatureUnknown Sequence> getSequencesForType(@SignatureUnknown TypedOperation operation, @SignatureUnknown int i, @SignatureUnknown boolean onlyReceivers) {
        Type neededType = operation.getInputTypes().get(i);
        if (onlyReceivers && neededType.isNonreceiverType()) {
            throw new RandoopBug(String.format("getSequencesForType(%s, %s, %s) neededType=%s", operation, i, onlyReceivers, neededType));
        }
        SimpleList<Sequence> result = this.gralComponents.getSequencesForType(neededType, false, onlyReceivers);
        ListOfLists literals = null;
        if (operation instanceof TypedClassOperation && !onlyReceivers) {
            ListOfLists sl;
            Package pkg;
            ListOfLists sl2;
            ClassOrInterfaceType declaringCls = ((TypedClassOperation)operation).getDeclaringType();
            assert (declaringCls != null);
            if (this.classLiterals != null && !(sl2 = this.classLiterals.getSequences(declaringCls, neededType)).isEmpty()) {
                literals = sl2;
            }
            if (this.packageLiterals != null && (pkg = declaringCls.getPackage()) != null && !(sl = this.packageLiterals.getSequences(pkg, neededType)).isEmpty()) {
                ListOfLists listOfLists = literals = literals == null ? sl : new ListOfLists(literals, sl);
            }
        }
        if (literals != null) {
            if (result == null) {
                result = literals;
            } else if (literals != null) {
                result = new ListOfLists<Sequence>(result, literals);
            }
        }
        return result;
    }

    @SignatureUnknown Set<@SignatureUnknown Sequence> getAllPrimitiveSequences() {
        LinkedHashSet<Sequence> result = new LinkedHashSet<Sequence>();
        if (this.classLiterals != null) {
            result.addAll(this.classLiterals.getAllSequences());
        }
        if (this.packageLiterals != null) {
            result.addAll(this.packageLiterals.getAllSequences());
        }
        for (PrimitiveType type : JavaTypes.getPrimitiveTypes()) {
            result.addAll(this.gralComponents.getSequencesForType(type, true, false).toJDKList());
        }
        result.addAll(this.gralComponents.getSequencesForType(JavaTypes.STRING_TYPE, true, false).toJDKList());
        return result;
    }

    @SignatureUnknown TypeInstantiator getTypeInstantiator() {
        return this.gralComponents.getTypeInstantiator();
    }

    public void log() {
        if (!Log.isLoggingOn()) {
            return;
        }
        this.gralComponents.log();
    }
}

