/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import randoop.generation.CoverageTracker;
import randoop.generation.TypedOperationSelector;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.operation.CallableOperation;
import randoop.operation.EnumConstant;
import randoop.operation.FieldGet;
import randoop.operation.FieldSet;
import randoop.operation.MethodCall;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.sequence.Sequence;
import randoop.types.ClassOrInterfaceType;
import randoop.util.Randomness;
import randoop.util.SimpleArrayList;

public class Bloodhound
implements TypedOperationSelector {
    private final @SignatureUnknown CoverageTracker coverageTracker;
    private final @SignatureUnknown Map<@SignatureUnknown TypedOperation, @SignatureUnknown Double> methodWeights = new HashMap<TypedOperation, Double>();
    private final @SignatureUnknown Map<@SignatureUnknown TypedOperation, @SignatureUnknown Integer> methodSelectionCounts = new HashMap<TypedOperation, Integer>();
    private final @SignatureUnknown Map<@SignatureUnknown TypedOperation, @SignatureUnknown Integer> methodInvocationCounts = new HashMap<TypedOperation, Integer>();
    private final @SignatureUnknown SimpleArrayList<@SignatureUnknown TypedOperation> operationSimpleList;
    private static final @SignatureUnknown double alpha = 0.9;
    private static final @SignatureUnknown double p = 0.99;
    private static final @SignatureUnknown long t = 50000L;
    private @SignatureUnknown long lastUpdateTime = 0L;
    private static final @SignatureUnknown int branchCoverageInterval = 100;
    private @SignatureUnknown int totalSuccessfulInvocations = 0;
    private @SignatureUnknown int maxSuccM = 1;
    private @SignatureUnknown double totalWeightOfMethodsUnderTest = 0.0;

    public Bloodhound(@SignatureUnknown List<@SignatureUnknown TypedOperation> operations, @SignatureUnknown Set<@SignatureUnknown ClassOrInterfaceType> classesUnderTest) {
        this.operationSimpleList = new SimpleArrayList<TypedOperation>(operations);
        this.coverageTracker = new CoverageTracker(classesUnderTest);
        this.updateBranchCoverageMaybe();
    }

    @Override
    public @SignatureUnknown TypedOperation selectOperation() {
        this.updateBranchCoverageMaybe();
        TypedOperation selectedOperation = Randomness.randomMemberWeighted(this.operationSimpleList, this.methodWeights, this.totalWeightOfMethodsUnderTest);
        CollectionsPlume.incrementMap(this.methodSelectionCounts, selectedOperation);
        this.updateWeight(selectedOperation);
        return selectedOperation;
    }

    private void updateBranchCoverageMaybe() {
        boolean shouldUpdateBranchCoverage;
        switch (GenInputsAbstract.bloodhound_update_mode) {
            case TIME: {
                long currentTime = System.currentTimeMillis();
                boolean bl = shouldUpdateBranchCoverage = currentTime - this.lastUpdateTime >= 50000L;
                if (!shouldUpdateBranchCoverage) break;
                this.lastUpdateTime = currentTime;
                break;
            }
            case INVOCATIONS: {
                boolean bl = shouldUpdateBranchCoverage = this.totalSuccessfulInvocations % 100 == 0;
                if (!shouldUpdateBranchCoverage) break;
                this.totalSuccessfulInvocations = 1;
                break;
            }
            default: {
                throw new RandoopBug("Unhandled value for bloodhound_update_mode: " + (Object)((Object)GenInputsAbstract.bloodhound_update_mode));
            }
        }
        if (shouldUpdateBranchCoverage) {
            if (GenInputsAbstract.bloodhound_logging) {
                System.out.println("Updating branch coverage information.");
            }
            this.methodSelectionCounts.clear();
            this.coverageTracker.updateBranchCoverageMap();
            this.updateWeightsForAllOperations();
            this.logMethodWeights();
        }
    }

    private void logMethodWeights() {
        if (GenInputsAbstract.bloodhound_logging) {
            System.out.println("Method name: method weight");
            for (TypedOperation typedOperation : new TreeSet<TypedOperation>(this.methodWeights.keySet())) {
                System.out.println(typedOperation.getName() + ": " + this.methodWeights.get(typedOperation));
            }
            System.out.println("--------------------------");
        }
    }

    private void updateWeightsForAllOperations() {
        double totalWeight = 0.0;
        for (TypedOperation operation : this.operationSimpleList) {
            totalWeight += this.updateWeight(operation);
        }
        this.totalWeightOfMethodsUnderTest = totalWeight;
    }

    private @SignatureUnknown double updateWeight(@SignatureUnknown TypedOperation operation) {
        double wmk;
        Integer succM;
        String methodName = operation.getName().replaceAll("<.*>\\.", ".");
        Double uncovRatio = this.coverageTracker.getBranchCoverageForMethod(methodName);
        if (uncovRatio == null) {
            boolean isExpectedToHaveNoCoverage;
            String operationName = operation.getName();
            CallableOperation callableOperation = operation.getOperation();
            boolean isAbstractMethod = false;
            boolean isSyntheticMethod = false;
            boolean isFromAbstractClass = false;
            if (callableOperation instanceof MethodCall) {
                Method method = ((MethodCall)callableOperation).getMethod();
                isAbstractMethod = Modifier.isAbstract(method.getModifiers());
                isSyntheticMethod = method.isSynthetic();
                isFromAbstractClass = Modifier.isAbstract(method.getDeclaringClass().getModifiers());
            }
            boolean isGetterMethod = callableOperation instanceof FieldGet;
            boolean isSetterMethod = callableOperation instanceof FieldSet;
            boolean isEnumConstant = callableOperation instanceof EnumConstant;
            boolean bl = isExpectedToHaveNoCoverage = isAbstractMethod || isGetterMethod || isSetterMethod || isEnumConstant || isSyntheticMethod || isFromAbstractClass || operationName.equals("java.lang.Object.<init>") || operationName.equals("java.lang.Object.getClass");
            if (!isExpectedToHaveNoCoverage) {
                System.err.println("The method " + methodName + " is expected to have coverage info but has none.");
            }
            assert (isExpectedToHaveNoCoverage);
            uncovRatio = 0.5;
        }
        if ((succM = this.methodInvocationCounts.get(operation)) == null) {
            succM = 0;
        }
        double wm0 = 0.9 * uncovRatio + 0.09999999999999998 * (1.0 - succM.doubleValue() / (double)this.maxSuccM);
        Integer k = this.methodSelectionCounts.get(operation);
        if (k == null) {
            wmk = wm0;
        } else {
            double val1 = -3.0 / Math.log(0.010000000000000009) * (Math.pow(0.99, k.intValue()) / (double)k.intValue());
            double val2 = 1.0 / Math.log((double)this.operationSimpleList.size() + 3.0);
            wmk = Math.max(val1, val2) * wm0;
        }
        Double existingWeight = this.methodWeights.get(operation);
        if (existingWeight == null) {
            existingWeight = 0.0;
        }
        this.methodWeights.put(operation, wmk);
        this.totalWeightOfMethodsUnderTest -= existingWeight.doubleValue();
        this.totalWeightOfMethodsUnderTest += wmk;
        return wmk;
    }

    public void incrementSuccessfulInvocationCount(@SignatureUnknown TypedOperation operation) {
        ++this.totalSuccessfulInvocations;
        CollectionsPlume.incrementMap(this.methodInvocationCounts, operation);
        int numSuccessfulInvocations = this.methodInvocationCounts.get(operation);
        this.maxSuccM = Math.max(this.maxSuccM, numSuccessfulInvocations);
    }

    @Override
    public void newRegressionTestHook(@SignatureUnknown Sequence sequence) {
        this.incrementSuccessfulInvocationCount(sequence.getOperation());
    }
}

