/*
 * Decompiled with CFR 0.152.
 */
package randoop.field;

import java.lang.reflect.Field;
import randoop.field.AccessibleField;
import randoop.operation.OperationParseException;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;

public class FieldParser {
    private FieldParser() {
        throw new Error("Do not instantiate");
    }

    public static @SignatureUnknown AccessibleField parse(@SignatureUnknown String descr, @ClassGetName String classname, @SignatureUnknown String fieldname) throws @SignatureUnknown OperationParseException {
        ClassOrInterfaceType classType;
        String errorPrefix = "Error when parsing field " + descr + ".";
        try {
            classType = (ClassOrInterfaceType)Type.forName(classname);
        }
        catch (ClassNotFoundException e) {
            String msg = errorPrefix + " Class for field " + descr + " not found: " + e.getMessage();
            throw new OperationParseException(msg);
        }
        String whitespacePattern = ".*\\s+.*";
        if (fieldname.matches(whitespacePattern)) {
            String msg = errorPrefix + " The field name " + fieldname + " has unexpected whitespace characters.";
            throw new OperationParseException(msg);
        }
        Field field = FieldParser.fieldForName(classType.getRuntimeClass(), fieldname);
        if (field == null) {
            String msg = errorPrefix + " The field name \"" + fieldname + "\" is not a field of the class \"" + classname + "\".";
            throw new OperationParseException(msg);
        }
        return new AccessibleField(field, classType);
    }

    private static @SignatureUnknown Field fieldForName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SignatureUnknown Class<@SignatureUnknown @SignatureBottom ?> type, @SignatureUnknown String fieldName) {
        for (Field f : type.getDeclaredFields()) {
            if (!fieldName.equals(f.getName())) continue;
            return f;
        }
        return null;
    }
}

