/*
 * Decompiled with CFR 0.152.
 */
package randoop.field;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.SequenceExecutionException;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;

public class AccessibleField {
    private @SignatureUnknown Field field;
    private final @SignatureUnknown ClassOrInterfaceType declaringType;
    private @SignatureUnknown boolean isFinal;
    private @SignatureUnknown boolean isStatic;

    public AccessibleField(@SignatureUnknown Field field, @SignatureUnknown ClassOrInterfaceType declaringType) {
        this.field = field;
        this.field.setAccessible(true);
        int mods = field.getModifiers() & Modifier.fieldModifiers();
        this.isFinal = Modifier.isFinal(mods);
        this.isStatic = Modifier.isStatic(mods);
        this.declaringType = declaringType;
    }

    public @SignatureUnknown String getName() {
        return this.field.getName();
    }

    public @SignatureUnknown String toCode(@SignatureUnknown Type declaringType, @SignatureUnknown List<@SignatureUnknown Variable> inputVars) {
        StringBuilder sb = new StringBuilder();
        if (this.isStatic) {
            sb.append(declaringType.getCanonicalName());
        } else {
            sb.append(inputVars.get(0).getName());
        }
        return sb.append(".").append(this.getName()).toString();
    }

    public @SignatureUnknown String toParsableString(@SignatureUnknown Type declaringType) {
        return declaringType.getBinaryName() + "." + this.field.getName();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return this.field.toString();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccessibleField)) {
            return false;
        }
        AccessibleField f = (AccessibleField)obj;
        return this.field.equals(f.field);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return this.field.hashCode();
    }

    public @SignatureUnknown Object getValue(@SignatureUnknown Object object) {
        Object ret;
        try {
            ret = this.field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new SequenceExecutionException("Field access to object of wrong type: ", e);
        }
        catch (IllegalAccessException e) {
            throw new RandoopBug("Access control violation for field: " + this.field.getName(), e);
        }
        return ret;
    }

    public void setValue(@SignatureUnknown Object object, @SignatureUnknown Object value) {
        assert (!this.isFinal) : "cannot set a final field";
        try {
            this.field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new SequenceExecutionException("Field set to object of wrong type", e);
        }
        catch (IllegalAccessException e) {
            throw new RandoopBug("Access control violation for field: ", e);
        }
    }

    public @SignatureUnknown boolean isStatic() {
        return this.isStatic;
    }

    public @SignatureUnknown boolean isFinal() {
        return this.isFinal;
    }

    public @SignatureUnknown boolean satisfies(@SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return reflectionPredicate.test(this.field);
    }

    public @SignatureUnknown Field getRawField() {
        return this.field;
    }

    public @SignatureUnknown ClassOrInterfaceType getDeclaringType() {
        return this.declaringType;
    }
}

