/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Objects;
import randoop.contract.ObjectContract;
import randoop.main.RandoopBug;
import randoop.operation.CallableOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Value;
import randoop.types.JavaTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.util.Log;

public final class ObserverEqValue
extends ObjectContract {
    public @SignatureUnknown TypedOperation observer;
    public @SignatureUnknown Object value;
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE));

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObserverEqValue)) {
            return false;
        }
        ObserverEqValue other = (ObserverEqValue)o;
        return this.observer.equals(other.observer) && Objects.equals(this.value, other.value);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.observer, this.value);
    }

    public ObserverEqValue(@SignatureUnknown TypedOperation observer, @SignatureUnknown Object value) {
        assert (observer.isMethodCall() || observer.isConstructorCall()) : "Observer must be MethodCall or ConstructorCall, got " + observer;
        this.observer = observer;
        this.value = value;
        if (!ObserverEqValue.isLiteralValue(value)) {
            throw new RandoopBug(String.format("Cannot represent %s as a literal; observer = %s", Log.toStringAndClass(value), observer));
        }
    }

    public static @SignatureUnknown boolean isLiteralValue(@SignatureUnknown Object value) {
        if (value == null) {
            return true;
        }
        Class<?> cls = value.getClass();
        if (cls == Class.class || cls == String.class || cls.isEnum()) {
            return true;
        }
        Type type = Type.forClass(cls);
        return type.isBoxedPrimitive();
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        String call;
        StringBuilder b = new StringBuilder();
        CallableOperation operation = this.observer.getOperation();
        String methodname = operation.getName();
        if (operation.isStatic()) {
            Executable m3 = (Executable)operation.getReflectionObject();
            String theClass = m3.getDeclaringClass().getName();
            call = String.format("%s.%s(x0)", theClass, methodname);
        } else {
            call = String.format("x0.%s()", methodname);
        }
        if (this.value == null) {
            b.append(String.format("org.junit.Assert.assertNull(\"%s == null\", %s);", call, call));
        } else if (this.observer.getOutputType().runtimeClassIs(Boolean.TYPE)) {
            assert (this.value.equals(true) || this.value.equals(false));
            if (this.value.equals(true)) {
                b.append(String.format("org.junit.Assert.assertTrue(%s);", call));
            } else {
                b.append(String.format("org.junit.Assert.assertFalse(%s);", call));
            }
        } else if (this.observer.getOutputType().isPrimitive() && !this.value.equals(Double.NaN) && !this.value.equals(Float.valueOf(Float.NaN))) {
            b.append(String.format("org.junit.Assert.assertEquals(%s, %s);", call, Value.toCodeString(this.value)));
        } else {
            b.append(String.format("org.junit.Assert.assertEquals(%s, %s);", call, Value.toCodeString(this.value)));
        }
        return b.toString();
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) throws @SignatureUnknown Throwable {
        assert (objects.length == 0);
        throw new RuntimeException("not implemented.");
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return this.toCodeString();
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return this.observer.toString();
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return String.format("<ObserverEqValue %s, value = '%s'", this.observer, Log.toStringAndClass(this.value));
    }
}

