/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.util.Arrays;
import randoop.Globals;
import randoop.contract.ObjectContract;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public final class EqualsSymmetric
extends ObjectContract {
    private static final @SignatureUnknown EqualsSymmetric instance = new EqualsSymmetric();
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE, JavaTypes.OBJECT_TYPE));

    private EqualsSymmetric() {
    }

    public static @SignatureUnknown EqualsSymmetric getInstance() {
        return instance;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) {
        Object o1 = objects[0];
        Object o2 = objects[1];
        return !o1.equals(o2) || o2.equals(o1);
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 2;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "equals-symmetric on x0 and x1.";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "equals-symmetric";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append(Globals.lineSep);
        b.append("// This assertion (symmetry of equals) fails ");
        b.append(Globals.lineSep);
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"Contract failed: " + this.toCommentString() + "\", ");
        b.append("x0.equals(x1) == x1.equals(x0)");
        b.append(");");
        return b.toString();
    }
}

