/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.util.Arrays;
import randoop.contract.ObjectContract;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public final class EqualsReturnsNormally
extends ObjectContract {
    private static final @SignatureUnknown EqualsReturnsNormally instance = new EqualsReturnsNormally();
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE));

    private EqualsReturnsNormally() {
    }

    public static @SignatureUnknown EqualsReturnsNormally getInstance() {
        return instance;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) {
        assert (objects != null && objects.length == 1);
        Object o = objects[0];
        assert (o != null);
        try {
            o.equals(o);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "x0.equals() throws no Exception.";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "equals() throws no Exception";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"Contract failed: " + this.toCommentString() + "\", ");
        b.append("x0.equals()");
        b.append(");");
        return b.toString();
    }
}

