/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.util.Arrays;
import randoop.contract.ObjectContract;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public final class EqualsReflexive
extends ObjectContract {
    private static final @SignatureUnknown EqualsReflexive instance = new EqualsReflexive();
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE));

    private EqualsReflexive() {
    }

    public static @SignatureUnknown EqualsReflexive getInstance() {
        return instance;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) {
        assert (objects != null && objects.length == 1);
        Object o = objects[0];
        assert (o != null);
        return o.equals(o);
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "x0.equals(x0)";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "EqualsReflexive";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"Contract failed: " + this.toCommentString() + "\", ");
        b.append("x0.equals(x0)");
        b.append(");");
        return b.toString();
    }
}

