/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.util.Arrays;
import randoop.contract.ObjectContract;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public class CompareToSubs
extends ObjectContract {
    private static final @SignatureUnknown CompareToSubs instance = new CompareToSubs();
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.COMPARABLE_TYPE, JavaTypes.COMPARABLE_TYPE, JavaTypes.COMPARABLE_TYPE));

    private CompareToSubs() {
    }

    public static @SignatureUnknown CompareToSubs getInstance() {
        return instance;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) {
        Object o1 = objects[0];
        Object o2 = objects[1];
        Object o3 = objects[2];
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable compObj1 = (Comparable)o1;
            Comparable compObj2 = (Comparable)o2;
            Comparable compObj3 = (Comparable)o3;
            return compObj1.compareTo(compObj2) != 0 || Math.signum(compObj1.compareTo(compObj3)) == Math.signum(compObj2.compareTo(compObj3));
        }
        return true;
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 3;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "compareTo-substitutability on x0, x1, and x2";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "CompareToSubstitutability";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"Contract failed: " + this.toCommentString() + "\", ");
        b.append("!(x0.compareTo(x1) == 0) || (Math.signum(x0.compareTo(x2)) == Math.signum(x1.compareTo(x2)))");
        b.append(");");
        return b.toString();
    }
}

