/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.util.Arrays;
import randoop.contract.ObjectContract;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public class CompareToEquals
extends ObjectContract {
    private static final @SignatureUnknown CompareToEquals instance = new CompareToEquals();
    static @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.COMPARABLE_TYPE, JavaTypes.COMPARABLE_TYPE));

    private CompareToEquals() {
    }

    public static @SignatureUnknown CompareToEquals getInstance() {
        return instance;
    }

    @Override
    public @SignatureUnknown boolean evaluate(Object ... objects) {
        Object o1 = objects[0];
        Object o2 = objects[1];
        if (o1 instanceof Comparable) {
            Comparable compObj1 = (Comparable)o1;
            return compObj1.compareTo(o2) == 0 == o1.equals(o2);
        }
        return true;
    }

    @Override
    public @SignatureUnknown int getArity() {
        return 2;
    }

    @Override
    public @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @SignatureUnknown String toCommentString() {
        return "compareTo-equals on x0 and x1";
    }

    @Override
    public @SignatureUnknown String get_observer_str() {
        return "CompareToEquals";
    }

    @Override
    public @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"Contract failed: " + this.toCommentString() + "\", ");
        b.append("(x0.compareTo(x1) == 0) == x0.equals(x1)");
        b.append(");");
        return b.toString();
    }
}

