/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import java.util.Objects;
import randoop.com.google.gson.annotations.SerializedName;
import randoop.condition.specification.Guard;
import randoop.condition.specification.SpecificationClause;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.ClassGetName;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class ThrowsCondition
extends SpecificationClause {
    @SerializedName(value="exception")
    private final @ClassGetName String exceptionType;

    private ThrowsCondition() {
        this.exceptionType = "";
    }

    public ThrowsCondition(@SignatureUnknown String description, @SignatureUnknown Guard guard, @ClassGetName String exceptionType) {
        super(description, guard);
        this.exceptionType = exceptionType;
    }

    public @ClassGetName String getExceptionTypeName() {
        return this.exceptionType;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ThrowsCondition)) {
            return false;
        }
        ThrowsCondition other = (ThrowsCondition)object;
        return super.equals(other) && this.exceptionType.equals(other.exceptionType);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(super.hashCode(), this.exceptionType);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "{ \"description\": \"" + this.getDescription() + "\", \"guard\": \"" + this.getGuard() + ", \"exceptionType\": " + this.exceptionType + "\" }";
    }
}

