/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import java.util.Objects;
import randoop.condition.specification.Guard;
import randoop.condition.specification.Property;
import randoop.condition.specification.SpecificationClause;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class Postcondition
extends SpecificationClause {
    private final @SignatureUnknown Property property;

    private Postcondition() {
        this.property = null;
    }

    public Postcondition(@SignatureUnknown String description, @SignatureUnknown Guard guard, @SignatureUnknown Property property) {
        super(description, guard);
        this.property = property;
    }

    public @SignatureUnknown Property getProperty() {
        return this.property;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Postcondition)) {
            return false;
        }
        Postcondition other = (Postcondition)object;
        return super.equals(other) && (this.property != null && other.property != null && this.property.equals(other.property) || this.property == null && other.property == null);
    }

    @Override
    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(super.hashCode(), this.property);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "{ \"description\": \"" + this.getDescription() + "\", \"guard\": \"" + this.getGuard() + ", \"property\": " + this.property + "\" }";
    }
}

