/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition.specification;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.com.google.gson.annotations.SerializedName;
import randoop.condition.specification.Identifiers;
import randoop.condition.specification.OperationSignature;
import randoop.condition.specification.Postcondition;
import randoop.condition.specification.Precondition;
import randoop.condition.specification.ThrowsCondition;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class OperationSpecification {
    private final @SignatureUnknown OperationSignature operation;
    private final @SignatureUnknown Identifiers identifiers;
    @SerializedName(value="pre")
    private final @SignatureUnknown List<@SignatureUnknown Precondition> preSpecifications;
    @SerializedName(value="post")
    private final @SignatureUnknown List<@SignatureUnknown Postcondition> postSpecifications;
    @SerializedName(value="throws")
    private final @SignatureUnknown List<@SignatureUnknown ThrowsCondition> throwsSpecifications;

    private OperationSpecification() {
        this.operation = null;
        this.identifiers = new Identifiers();
        this.preSpecifications = new ArrayList<Precondition>();
        this.postSpecifications = new ArrayList<Postcondition>();
        this.throwsSpecifications = new ArrayList<ThrowsCondition>();
    }

    public OperationSpecification(@SignatureUnknown OperationSignature operation, @SignatureUnknown Identifiers identifiers) {
        this(operation, identifiers, new ArrayList<Precondition>(), new ArrayList<Postcondition>(), new ArrayList<ThrowsCondition>());
    }

    public OperationSpecification(@SignatureUnknown OperationSignature operation, @SignatureUnknown Identifiers identifiers, @SignatureUnknown List<@SignatureUnknown Precondition> preSpecifications, @SignatureUnknown List<@SignatureUnknown Postcondition> postSpecifications, @SignatureUnknown List<@SignatureUnknown ThrowsCondition> throwsSpecifications) {
        this.operation = operation;
        this.identifiers = identifiers;
        this.preSpecifications = preSpecifications;
        this.postSpecifications = postSpecifications;
        this.throwsSpecifications = throwsSpecifications;
    }

    public @SignatureUnknown OperationSignature getOperation() {
        return this.operation;
    }

    public @SignatureUnknown Identifiers getIdentifiers() {
        return this.identifiers;
    }

    public @SignatureUnknown List<@SignatureUnknown Precondition> getPreconditions() {
        return this.preSpecifications;
    }

    public @SignatureUnknown List<@SignatureUnknown Postcondition> getPostconditions() {
        return this.postSpecifications;
    }

    public @SignatureUnknown List<@SignatureUnknown ThrowsCondition> getThrowsConditions() {
        return this.throwsSpecifications;
    }

    public void addParamSpecifications(@SignatureUnknown List<@SignatureUnknown Precondition> specifications) {
        this.preSpecifications.addAll(specifications);
    }

    public void addReturnSpecifications(@SignatureUnknown List<@SignatureUnknown Postcondition> specifications) {
        this.postSpecifications.addAll(specifications);
    }

    public void addThrowsConditions(@SignatureUnknown List<@SignatureUnknown ThrowsCondition> specifications) {
        this.throwsSpecifications.addAll(specifications);
    }

    public @SignatureUnknown boolean isEmpty() {
        return this.preSpecifications.isEmpty() && this.postSpecifications.isEmpty() && this.throwsSpecifications.isEmpty();
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @SignatureUnknown boolean equals(@SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OperationSpecification)) {
            return false;
        }
        OperationSpecification other = (OperationSpecification)object;
        return this.operation.equals(other.operation) && this.identifiers.equals(other.identifiers) && this.preSpecifications.equals(other.preSpecifications) && this.postSpecifications.equals(other.postSpecifications) && this.throwsSpecifications.equals(other.throwsSpecifications);
    }

    @Pure
    public @SignatureUnknown int hashCode() {
        return Objects.hash(this.operation, this.identifiers, this.preSpecifications, this.postSpecifications, this.throwsSpecifications);
    }

    @SideEffectFree
    public @SignatureUnknown String toString() {
        return "{ \"operation\": " + this.operation.toString() + ", \"identifiers\": " + this.identifiers + ", \"preSpecifications\": " + this.preSpecifications + " }, \"postSpecifications\": " + this.postSpecifications + ", \"throwsSpecifications\": " + this.throwsSpecifications;
    }
}

